/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver singleton = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return singleton;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver persistenceProviderResolver) {
        singleton = persistenceProviderResolver == null ? new DefaultPersistenceProviderResolver() : persistenceProviderResolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
        public static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Set<String> set = this.getProviderNames(classLoader);
            ArrayList<PersistenceProvider> arrayList = new ArrayList<PersistenceProvider>();
            for (String string : set) {
                try {
                    PersistenceProvider persistenceProvider = (PersistenceProvider)classLoader.loadClass(string).newInstance();
                    arrayList.add(persistenceProvider);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            return arrayList;
        }

        private Set<String> getProviderNames(ClassLoader classLoader) {
            Enumeration<URL> enumeration = null;
            try {
                enumeration = classLoader.getResources(SERVICE_PROVIDER_FILE);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                hashSet.addAll(this.getProviderNames(uRL));
            }
            return hashSet;
        }

        private Set<String> getProviderNames(URL uRL) {
            HashSet<String> hashSet = new HashSet<String>();
            InputStream inputStream = null;
            try {
                String string;
                inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    Matcher matcher = nonCommentPattern.matcher(string = string.trim());
                    if (!matcher.find()) continue;
                    hashSet.add(matcher.group().trim());
                }
            }
            catch (IOException iOException) {
                throw new PersistenceException("IOException caught reading: " + uRL);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return hashSet;
        }
    }
}

