/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.glassfish.admin.mbeanserver.PendingConfigBeanJob;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.CageBuilder;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="PendingConfigBeans")
public class PendingConfigBeans
implements CageBuilder,
PostConstruct,
TransactionListener {
    @Inject
    Transactions transactions;
    private final LinkedBlockingQueue<PendingConfigBeanJob> mJobs = new LinkedBlockingQueue();

    protected static void debug(String s) {
        System.out.println(s);
    }

    public int size() {
        return this.mJobs.size();
    }

    public void postConstruct() {
        this.transactions.addTransactionsListener((TransactionListener)this);
    }

    final ConfigBean asConfigBean(Object o) {
        return o instanceof ConfigBean ? (ConfigBean)ConfigBean.class.cast(o) : null;
    }

    public void onEntered(Inhabitant<?> inhabitant) {
        ConfigBean cb = this.asConfigBean(inhabitant);
        if (cb != null) {
            this.add(cb);
        }
    }

    public PendingConfigBeanJob take() throws InterruptedException {
        return this.mJobs.take();
    }

    public PendingConfigBeanJob peek() throws InterruptedException {
        return this.mJobs.peek();
    }

    private PendingConfigBeanJob addJob(PendingConfigBeanJob job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        this.mJobs.add(job);
        return job;
    }

    public PendingConfigBeanJob add(ConfigBean cb) {
        return this.add(cb, null);
    }

    public PendingConfigBeanJob add(ConfigBean cb, boolean useLatch) {
        return this.add(cb, useLatch ? new CountDownLatch(1) : null);
    }

    public PendingConfigBeanJob add(ConfigBean cb, CountDownLatch latch) {
        return this.addJob(new PendingConfigBeanJob(cb, latch));
    }

    public boolean remove(ConfigBean cb) {
        boolean found = false;
        for (PendingConfigBeanJob job : this.mJobs) {
            if (job.getConfigBean() != cb) continue;
            found = true;
            job.releaseLatch();
            this.mJobs.remove(job);
            break;
        }
        if (found) {
            this.removeAllDescendants(cb);
        }
        return found;
    }

    private void removeAllDescendants(ConfigBean cb) {
        ArrayList<PendingConfigBeanJob> jobs = new ArrayList<PendingConfigBeanJob>(this.mJobs);
        for (PendingConfigBeanJob job : jobs) {
            if (!this.isDescendent(job.getConfigBean(), cb)) continue;
            this.mJobs.remove(job);
        }
    }

    private boolean isDescendent(ConfigBean candidate, ConfigBean parent) {
        boolean isParent = false;
        for (Dom temp = candidate.parent(); temp != null; temp = temp.parent()) {
            if (temp != parent) continue;
            isParent = true;
            break;
        }
        return isParent;
    }

    public synchronized void swapTransactionListener(TransactionListener newListener) {
        this.transactions.addTransactionsListener(newListener);
        this.transactions.removeTransactionsListener((TransactionListener)this);
    }

    public synchronized void transactionCommited(List<PropertyChangeEvent> events) {
        for (PropertyChangeEvent event : events) {
            ConfigBean cb;
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            Object source = event.getSource();
            String propertyName = event.getPropertyName();
            if (oldValue == null && newValue instanceof ConfigBeanProxy) {
                cb = this.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)((ConfigBeanProxy)newValue)));
                this.add(cb);
                continue;
            }
            if (newValue != null || !(oldValue instanceof ConfigBeanProxy)) continue;
            cb = this.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)((ConfigBeanProxy)oldValue)));
            this.remove(cb);
        }
    }

    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }
}

