/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.bootstrap;

import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.File;
import java.util.Properties;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class StartupContext {
    final File root;
    final Properties args;
    final long timeZero;
    public static final String TIME_ZERO_NAME = "__time_zero";

    public StartupContext() {
        this.root = new File(System.getProperty("user.dir"));
        this.timeZero = System.currentTimeMillis();
        this.args = new Properties();
    }

    public StartupContext(File root, String[] args) {
        this.root = this.absolutize(root);
        this.args = ArgumentManager.argsToMap(args);
        this.timeZero = System.currentTimeMillis();
    }

    public StartupContext(File root, Properties args) {
        this.root = root;
        this.args = args;
        this.timeZero = args.containsKey(TIME_ZERO_NAME) ? Long.decode(args.getProperty(TIME_ZERO_NAME)) : System.currentTimeMillis();
    }

    public File getRootDirectory() {
        return this.root;
    }

    public Properties getArguments() {
        return this.args;
    }

    public long getCreationTime() {
        return this.timeZero;
    }

    private File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }
}

