/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.enterprise.loader.EJBClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectorsClassLoaderUtil {
    @Inject
    private ClassLoaderHierarchy clh;

    public ConnectorClassFinder createRARClassLoader(String moduleDir, ClassLoader deploymentParent) {
        ClassLoader parent = null;
        parent = deploymentParent == null ? this.clh.getConnectorClassLoader(null).getParent() : deploymentParent;
        return this.createRARClassLoader(parent, moduleDir);
    }

    private ConnectorClassFinder createRARClassLoader(ClassLoader parent, String moduleDir) {
        ConnectorClassFinder cl = new ConnectorClassFinder(parent);
        File file = new File(moduleDir);
        try {
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, (EJBClassLoader)cl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return cl;
    }

    private void appendJars(File moduleDir, EJBClassLoader cl) throws MalformedURLException {
        if (moduleDir.isDirectory()) {
            for (File file : moduleDir.listFiles()) {
                if (file.getName().toUpperCase().endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }
}

