/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.initialization;

import com.sun.appserv.ha.util.PersistenceTypeResolver;
import com.sun.ejb.base.sfsb.initialization.FileStrategyBuilder;
import com.sun.ejb.spi.sfsb.initialization.PersistenceStrategyBuilder;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistenceStrategyBuilderFactory {
    protected final String DEFAULT_EE_BUILDER_PATH = "com.sun.ejb.ee.sfsb.initialization";
    private static final Logger _logger = LogDomains.getLogger(PersistenceStrategyBuilderFactory.class, (String)"javax.enterprise.system.container.ejb");

    private static void debug(String s) {
    }

    public PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType) {
        String passedInPersistenceType = persistenceType;
        PersistenceStrategyBuilder builder = new FileStrategyBuilder();
        String className = this.createClassNameFrom(persistenceType);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + className);
        }
        boolean requestedBuilderCreated = false;
        try {
            builder = (PersistenceStrategyBuilder)Class.forName(className).newInstance();
            requestedBuilderCreated = true;
        }
        catch (ClassNotFoundException clnfEx) {
            _logger.log(Level.WARNING, "Couldn't find class: " + className + " for persistenceType: " + persistenceType);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception while creating Builder", clnfEx);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Exception while creating Builder", ex);
        }
        if (!requestedBuilderCreated) {
            _logger.log(Level.WARNING, "Couldn't create builder for persistence type: " + persistenceType + ". Instead created FileStrategyBuilder....");
        }
        builder.setPassedInPersistenceType(passedInPersistenceType);
        return builder;
    }

    private String createClassNameFrom(String persistenceType) {
        StringBuffer sb = new StringBuffer();
        String pkg = this.getClass().getPackage().getName();
        if (!persistenceType.equalsIgnoreCase("file")) {
            pkg = this.getEEBuilderPath();
        }
        sb.append(pkg + ".");
        sb.append(this.camelCase(persistenceType));
        sb.append("StrategyBuilder");
        String classname = sb.toString();
        return classname;
    }

    private String camelCase(String inputString) {
        String strippedString = this.stripNonAlphas(inputString);
        String firstLetter = strippedString.substring(0, 1).toUpperCase();
        String remainingPart = strippedString.substring(1, strippedString.length()).toLowerCase();
        return firstLetter + remainingPart;
    }

    private String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    private String getEEBuilderPath() {
        return "com.sun.ejb.ee.sfsb.initialization";
    }

    private PersistenceTypeResolver getPersistenceTypeResolver() {
        String resolverClassName = "com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver";
        PersistenceTypeResolver persistenceTypeResolver = null;
        try {
            persistenceTypeResolver = (PersistenceTypeResolver)Class.forName(resolverClassName).newInstance();
        }
        catch (Exception ex) {
            PersistenceStrategyBuilderFactory.debug("unable to create persistence type resolver");
        }
        return persistenceTypeResolver;
    }
}

