/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.initialization;

import com.sun.appserv.ha.util.PersistenceTypeResolver;
import com.sun.ejb.base.sfsb.store.FileTxStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFSBTxStoreManagerFactory {
    private static final Logger _logger = LogDomains.getLogger(SFSBTxStoreManagerFactory.class, (String)"javax.enterprise.system.container.ejb");
    protected static final String DEFAULT_EE_PACKAGE = "com.sun.ejb.ee.sfsb.store";

    public static SFSBTxStoreManager createSFSBTxStoreManager(String persistenceType) {
        if ("file".equalsIgnoreCase(persistenceType)) {
            return new FileTxStoreManager();
        }
        String resolvedPersistenceType = SFSBTxStoreManagerFactory.getResolvedPersistenceType(persistenceType);
        Exception exception = null;
        try {
            String className = SFSBTxStoreManagerFactory.createClassNameFrom(resolvedPersistenceType);
            return (SFSBTxStoreManager)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfEx) {
            exception = cnfEx;
            _logger.log(Level.FINE, "Exception while creating SFSBTxStoreManager for persistence type: " + persistenceType + ". Exception: " + cnfEx);
        }
        catch (Exception ex) {
            exception = ex;
            _logger.log(Level.FINE, "Exception while creating SFSBTxStoreManager for persistence type: " + persistenceType, ex);
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "Created FileTxStoreManager for persistence type: " + persistenceType, exception);
        }
        return new FileTxStoreManager();
    }

    private static String createClassNameFrom(String persistenceType) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(SFSBTxStoreManagerFactory.getEEPackage()).append(".").append(SFSBTxStoreManagerFactory.camelCase(persistenceType)).append("TxStoreManager");
        String classname = sbuf.toString();
        return classname;
    }

    private static String camelCase(String inputString) {
        String strippedString = SFSBTxStoreManagerFactory.stripNonAlphas(inputString);
        String firstLetter = strippedString.substring(0, 1).toUpperCase();
        String remainingPart = strippedString.substring(1, strippedString.length()).toLowerCase();
        return firstLetter + remainingPart;
    }

    private static String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    private static String getEEPackage() {
        return DEFAULT_EE_PACKAGE;
    }

    private static String getResolvedPersistenceType(String persistenceType) {
        String resolverClassName = "com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver";
        String resolvedPersistenceType = persistenceType;
        PersistenceTypeResolver persistenceTypeResolver = null;
        try {
            persistenceTypeResolver = (PersistenceTypeResolver)Class.forName(resolverClassName).newInstance();
            if (persistenceTypeResolver != null) {
                resolvedPersistenceType = persistenceTypeResolver.resolvePersistenceType(persistenceType);
                if ("memory".equalsIgnoreCase(resolvedPersistenceType)) {
                    resolvedPersistenceType = "file";
                } else if ("replicated".equalsIgnoreCase(resolvedPersistenceType)) {
                    resolvedPersistenceType = "ha";
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "unable to create persistence type resolver");
        }
        return resolvedPersistenceType;
    }
}

