/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.config.AbstractHttpHandler;
import com.sun.grizzly.config.ContextRootInfo;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collections;

public class WebProtocolHandler
extends AbstractHttpHandler
implements ProtocolHandler {
    protected String[][] protocols = new String[][]{{"http"}, {"https"}, {"https", "http"}, {"sip"}, {"sip", "sip_tls"}};
    private Mode mode;

    public WebProtocolHandler(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this(Mode.HTTP, grizzlyEmbeddedHttp);
    }

    public WebProtocolHandler(Mode mode, GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        super(grizzlyEmbeddedHttp);
        this.mode = mode;
    }

    public boolean handle(Context context, PUProtocolRequest protocolRequest) throws IOException {
        this.initDefaultHttpArtifactsIfRequired();
        ByteBuffer byteBuffer = protocolRequest.getByteBuffer();
        boolean mappedOk = this.initializeHttpRequestProcessing(context, byteBuffer);
        protocolRequest.setExecuteFilterChain(mappedOk);
        return mappedOk;
    }

    public String[] getProtocols() {
        return this.protocols[this.mode.ordinal()];
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }

    private synchronized void initDefaultHttpArtifactsIfRequired() {
        if (this.getDefaultProtocolFilters() == null) {
            this.getGrizzlyEmbeddedHttp().initAlgorithm();
            ArrayList<ProtocolFilter> tmpProtocolFilters = new ArrayList<ProtocolFilter>(4);
            tmpProtocolFilters.addAll(this.getGrizzlyEmbeddedHttp().getDefaultHttpProtocolFilters());
            StaticResourcesAdapter adapter = new StaticResourcesAdapter();
            adapter.setRootFolder(GrizzlyEmbeddedHttp.getWebAppRootPath());
            this.setFallbackContextRootInfo(new ContextRootInfo((Adapter)adapter, null, Collections.singletonList(new DefaultProtocolFilter(StaticStreamAlgorithm.class, this.getGrizzlyEmbeddedHttp().getPort()))));
            this.setDefaultProtocolFilters(tmpProtocolFilters);
        }
    }

    public ByteBuffer getByteBuffer() {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        if (workerThread.getSSLEngine() != null) {
            return workerThread.getInputBB();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        HTTP,
        HTTPS,
        HTTP_HTTPS,
        SIP,
        SIP_TLS;

    }
}

