/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.GenerationType;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitDefaults;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProject {
    private static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    private static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    private static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    private static final String DEFAULT_IDENTITY_GENERATOR = "SEQ_GEN_IDENTITY";
    private boolean m_weaveEager;
    private boolean m_weavingEnabled;
    private PersistenceUnitInfo m_persistenceUnitInfo;
    private AbstractSession m_session;
    private MetadataLogger m_logger;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;
    private HashMap<URL, XMLEntityMappings> m_entityMappings;
    private HashMap<String, MappedSuperclassAccessor> m_mappedSuperclasses;
    private HashMap<String, ClassAccessor> m_allAccessors;
    private HashMap<String, EntityAccessor> m_entityAccessors;
    private HashMap<String, EmbeddableAccessor> m_embeddableAccessors;
    private HashMap<String, InterfaceAccessor> m_interfaceAccessors;
    private HashMap<String, NamedQueryMetadata> m_queries;
    private HashMap<String, SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private HashMap<Class, GeneratedValueMetadata> m_generatedValues;
    private HashMap<String, TableGeneratorMetadata> m_tableGenerators;
    private HashMap<String, SequenceGeneratorMetadata> m_sequenceGenerators;
    private HashMap<String, AbstractConverterMetadata> m_converters;
    private HashSet<EntityListenerMetadata> m_defaultListeners;
    private HashSet<ClassAccessor> m_accessorsWithCustomizer;
    private HashSet<ClassAccessor> m_accessorsWithDerivedIDs;
    private HashSet<DirectCollectionAccessor> m_directCollectionAccessors;
    private HashSet<MappingAccessor> m_embeddableMappingAccessors;
    private HashSet<RelationshipAccessor> m_relationshipAccessors;

    public MetadataProject(PersistenceUnitInfo persistenceUnitInfo, AbstractSession abstractSession, boolean bl, boolean bl2) {
        this.m_persistenceUnitInfo = persistenceUnitInfo;
        this.m_session = abstractSession;
        this.m_logger = new MetadataLogger(abstractSession);
        this.m_weavingEnabled = bl;
        this.m_weaveEager = bl2;
        this.m_entityMappings = new LinkedHashMap<URL, XMLEntityMappings>();
        this.m_defaultListeners = new LinkedHashSet<EntityListenerMetadata>();
        this.m_queries = new HashMap();
        this.m_sqlResultSetMappings = new HashMap();
        this.m_mappedSuperclasses = new HashMap();
        this.m_allAccessors = new HashMap();
        this.m_entityAccessors = new HashMap();
        this.m_embeddableAccessors = new HashMap();
        this.m_interfaceAccessors = new HashMap();
        this.m_accessorsWithCustomizer = new HashSet();
        this.m_relationshipAccessors = new HashSet();
        this.m_embeddableMappingAccessors = new HashSet();
        this.m_directCollectionAccessors = new HashSet();
        this.m_generatedValues = new HashMap();
        this.m_tableGenerators = new HashMap();
        this.m_sequenceGenerators = new HashMap();
        this.m_converters = new HashMap();
        this.m_accessorsWithDerivedIDs = new HashSet();
    }

    protected void addAccessor(ClassAccessor classAccessor) {
        MetadataDescriptor metadataDescriptor = classAccessor.getDescriptor();
        if (this.m_persistenceUnitMetadata != null) {
            metadataDescriptor.setIgnoreAnnotations(this.m_persistenceUnitMetadata.isXMLMappingMetadataComplete());
            metadataDescriptor.setIgnoreDefaultMappings(this.m_persistenceUnitMetadata.excludeDefaultMappings());
            XMLPersistenceUnitDefaults xMLPersistenceUnitDefaults = this.m_persistenceUnitMetadata.getPersistenceUnitDefaults();
            if (xMLPersistenceUnitDefaults != null) {
                metadataDescriptor.setDefaultAccess(xMLPersistenceUnitDefaults.getAccess());
                metadataDescriptor.setDefaultSchema(xMLPersistenceUnitDefaults.getSchema());
                metadataDescriptor.setDefaultCatalog(xMLPersistenceUnitDefaults.getCatalog());
                metadataDescriptor.setIsCascadePersist(xMLPersistenceUnitDefaults.isCascadePersist());
            }
        }
        this.m_session.getProject().addDescriptor(metadataDescriptor.getClassDescriptor());
        this.m_allAccessors.put(classAccessor.getJavaClassName(), classAccessor);
    }

    public void addAccessorWithCustomizer(ClassAccessor classAccessor) {
        this.m_accessorsWithCustomizer.add(classAccessor);
    }

    public void addAccessorWithDerivedIDs(ClassAccessor classAccessor) {
        this.m_accessorsWithDerivedIDs.add(classAccessor);
    }

    public void addAlias(String string, MetadataDescriptor metadataDescriptor) {
        ClassDescriptor classDescriptor = this.m_session.getProject().getDescriptorForAlias(string);
        if (classDescriptor != null) {
            throw ValidationException.nonUniqueEntityName((String)classDescriptor.getJavaClassName(), (String)metadataDescriptor.getJavaClassName(), (String)string);
        }
        metadataDescriptor.setAlias(string);
        this.m_session.getProject().addAlias(string, metadataDescriptor.getClassDescriptor());
    }

    public void addConverter(AbstractConverterMetadata abstractConverterMetadata) {
        if (abstractConverterMetadata.shouldOverride(this.m_converters.get(abstractConverterMetadata.getName()))) {
            this.m_converters.put(abstractConverterMetadata.getName(), abstractConverterMetadata);
        }
    }

    public void addDefaultListener(EntityListenerMetadata entityListenerMetadata) {
        this.m_defaultListeners.add(entityListenerMetadata);
    }

    public void addDirectCollectionAccessor(MappingAccessor mappingAccessor) {
        this.m_directCollectionAccessors.add((DirectCollectionAccessor)mappingAccessor);
    }

    public void addEmbeddableAccessor(EmbeddableAccessor embeddableAccessor) {
        this.addAccessor(embeddableAccessor);
        embeddableAccessor.getDescriptor().setIsEmbeddable();
        this.m_embeddableAccessors.put(embeddableAccessor.getJavaClassName(), embeddableAccessor);
    }

    public void addEmbeddableMappingAccessor(MappingAccessor mappingAccessor) {
        this.m_embeddableMappingAccessors.add(mappingAccessor);
    }

    public void addEntityAccessor(EntityAccessor entityAccessor) {
        this.addAccessor(entityAccessor);
        this.m_entityAccessors.put(entityAccessor.getJavaClassName(), entityAccessor);
    }

    public void addEntityMappings(XMLEntityMappings xMLEntityMappings) {
        this.m_entityMappings.put(xMLEntityMappings.getMappingFile(), xMLEntityMappings);
    }

    public void addGeneratedValue(GeneratedValueMetadata generatedValueMetadata, Class clazz) {
        this.m_generatedValues.put(clazz, generatedValueMetadata);
    }

    public void addInterfaceAccessor(InterfaceAccessor interfaceAccessor) {
        this.m_interfaceAccessors.put(interfaceAccessor.getJavaClassName(), interfaceAccessor);
        this.m_session.getProject().addDescriptor(interfaceAccessor.getDescriptor().getClassDescriptor());
    }

    public void addMappedSuperclass(String string, MappedSuperclassAccessor mappedSuperclassAccessor) {
        if (this.m_mappedSuperclasses.containsKey(string)) {
            this.m_mappedSuperclasses.get(string).merge(mappedSuperclassAccessor);
        } else {
            this.m_mappedSuperclasses.put(string, mappedSuperclassAccessor);
        }
    }

    public void addQuery(NamedQueryMetadata namedQueryMetadata) {
        if (namedQueryMetadata.shouldOverride(this.m_queries.get(namedQueryMetadata.getName()))) {
            this.m_queries.put(namedQueryMetadata.getName(), namedQueryMetadata);
        }
    }

    public void addRelationshipAccessor(MappingAccessor mappingAccessor) {
        this.m_relationshipAccessors.add((RelationshipAccessor)mappingAccessor);
    }

    public void addSequenceGenerator(SequenceGeneratorMetadata sequenceGeneratorMetadata) {
        String string = sequenceGeneratorMetadata.getName();
        if (string.equals(DEFAULT_TABLE_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_TABLE_GENERATOR, (Object)sequenceGeneratorMetadata.getLocation());
        }
        if (string.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (Object)sequenceGeneratorMetadata.getLocation());
        }
        TableGeneratorMetadata tableGeneratorMetadata = this.m_tableGenerators.get(string);
        if (tableGeneratorMetadata != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)string, (Object)sequenceGeneratorMetadata.getLocation(), (Object)tableGeneratorMetadata.getLocation());
        }
        for (TableGeneratorMetadata tableGeneratorMetadata2 : this.m_tableGenerators.values()) {
            if (!tableGeneratorMetadata2.getPkColumnValue().equals(sequenceGeneratorMetadata.getSequenceName()) || tableGeneratorMetadata2.getPkColumnValue().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGeneratorMetadata.getSequenceName(), (Object)sequenceGeneratorMetadata.getLocation(), (Object)tableGeneratorMetadata2.getLocation());
        }
        if (sequenceGeneratorMetadata.shouldOverride(this.m_sequenceGenerators.get(string))) {
            this.m_sequenceGenerators.put(sequenceGeneratorMetadata.getName(), sequenceGeneratorMetadata);
        }
    }

    public void addSQLResultSetMapping(SQLResultSetMappingMetadata sQLResultSetMappingMetadata) {
        if (sQLResultSetMappingMetadata.shouldOverride(this.m_sqlResultSetMappings.get(sQLResultSetMappingMetadata.getName()))) {
            this.m_sqlResultSetMappings.put(sQLResultSetMappingMetadata.getName(), sQLResultSetMappingMetadata);
        }
    }

    public void addTableGenerator(TableGeneratorMetadata tableGeneratorMetadata, String string, String string2) {
        this.processTable(tableGeneratorMetadata, "SEQUENCE", string, string2);
        String string3 = tableGeneratorMetadata.getGeneratorName();
        if (string3.equals(DEFAULT_SEQUENCE_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_SEQUENCE_GENERATOR, (Object)tableGeneratorMetadata.getLocation());
        }
        if (string3.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (Object)tableGeneratorMetadata.getLocation());
        }
        SequenceGeneratorMetadata sequenceGeneratorMetadata = this.m_sequenceGenerators.get(string3);
        if (sequenceGeneratorMetadata != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)string3, (Object)sequenceGeneratorMetadata.getLocation(), (Object)tableGeneratorMetadata.getLocation());
        }
        for (SequenceGeneratorMetadata sequenceGeneratorMetadata2 : this.m_sequenceGenerators.values()) {
            if (!sequenceGeneratorMetadata2.getSequenceName().equals(tableGeneratorMetadata.getPkColumnValue()) || sequenceGeneratorMetadata2.getSequenceName().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGeneratorMetadata2.getSequenceName(), (Object)sequenceGeneratorMetadata2.getLocation(), (Object)tableGeneratorMetadata.getLocation());
        }
        if (tableGeneratorMetadata.shouldOverride(this.m_tableGenerators.get(string3))) {
            this.m_tableGenerators.put(string3, tableGeneratorMetadata);
        }
    }

    public ClassAccessor getAccessor(String string) {
        return this.m_allAccessors.get(string);
    }

    public Set<ClassAccessor> getAccessorsWithCustomizer() {
        return this.m_accessorsWithCustomizer;
    }

    public Set<ClassAccessor> getAccessorsWithDerivedIDs() {
        return this.m_accessorsWithDerivedIDs;
    }

    public Collection<ClassAccessor> getAllAccessors() {
        return this.m_allAccessors.values();
    }

    public AbstractConverterMetadata getConverter(String string) {
        return this.m_converters.get(string);
    }

    public Set<EntityListenerMetadata> getDefaultListeners() {
        return this.m_defaultListeners;
    }

    public EmbeddableAccessor getEmbeddableAccessor(Class clazz) {
        MetadataClass metadataClass;
        EmbeddableAccessor embeddableAccessor = this.m_embeddableAccessors.get(clazz.getName());
        if (embeddableAccessor == null && (metadataClass = new MetadataClass(clazz)).isAnnotationPresent(Embeddable.class)) {
            embeddableAccessor = new EmbeddableAccessor((Annotation)metadataClass.getAnnotation(Embeddable.class), clazz, this);
            this.addEmbeddableAccessor(embeddableAccessor);
        }
        return embeddableAccessor;
    }

    public EntityAccessor getEntityAccessor(String string) {
        return this.m_entityAccessors.get(string);
    }

    public Collection<EntityAccessor> getEntityAccessors() {
        return this.m_entityAccessors.values();
    }

    public Collection<XMLEntityMappings> getEntityMappings() {
        return this.m_entityMappings.values();
    }

    public InterfaceAccessor getInterfaceAccessor(String string) {
        return this.m_interfaceAccessors.get(string);
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    public MappedSuperclassAccessor getMappedSuperclass(Class clazz) {
        return this.m_mappedSuperclasses.get(clazz.getName());
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.m_persistenceUnitInfo;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public List<StructConverterMetadata> getStructConverters() {
        ArrayList<StructConverterMetadata> arrayList = new ArrayList<StructConverterMetadata>();
        for (AbstractConverterMetadata abstractConverterMetadata : this.m_converters.values()) {
            if (!abstractConverterMetadata.isStructConverter()) continue;
            arrayList.add((StructConverterMetadata)abstractConverterMetadata);
        }
        return arrayList;
    }

    public Collection<String> getWeavableClassNames() {
        return Collections.unmodifiableCollection(this.m_allAccessors.keySet());
    }

    public boolean hasConverter(String string) {
        return this.m_converters.containsKey(string);
    }

    public boolean hasEmbeddable(Class clazz) {
        return this.m_embeddableAccessors.containsKey(clazz.getName());
    }

    public boolean hasEntity(Class clazz) {
        return this.m_entityAccessors.containsKey(clazz.getName());
    }

    public boolean hasInterface(Class clazz) {
        return this.m_interfaceAccessors.containsKey(clazz.getName());
    }

    public boolean hasMappedSuperclass(Class clazz) {
        return this.m_mappedSuperclasses.containsKey(clazz.getName());
    }

    public boolean isWeavingEnabled() {
        return this.m_weavingEnabled;
    }

    protected void processEmbeddableMappingAccessors() {
        for (MappingAccessor mappingAccessor : this.m_embeddableMappingAccessors) {
            if (mappingAccessor.isProcessed()) continue;
            mappingAccessor.process();
        }
    }

    protected void processAccessorsWithDerivedIDs() {
        HashSet<ClassAccessor> hashSet = new HashSet<ClassAccessor>();
        HashSet<ClassAccessor> hashSet2 = new HashSet<ClassAccessor>();
        for (ClassAccessor classAccessor : this.getAccessorsWithDerivedIDs()) {
            classAccessor.processDerivedIDs(hashSet2, hashSet);
        }
    }

    public void processDirectCollectionAccessors() {
        for (DirectCollectionAccessor directCollectionAccessor : this.m_directCollectionAccessors) {
            directCollectionAccessor.process();
        }
    }

    protected void processInterfaceAccessors() {
        for (EntityAccessor entityAccessor : this.getEntityAccessors()) {
            for (Class<?> clazz : entityAccessor.getJavaClass().getInterfaces()) {
                if (!this.m_interfaceAccessors.containsKey(clazz.getName())) continue;
                this.m_interfaceAccessors.get(clazz.getName()).addEntityAccessor(entityAccessor);
            }
        }
    }

    public void processQueries(ClassLoader classLoader) {
        for (SQLResultSetMappingMetadata oRMetadata : this.m_sqlResultSetMappings.values()) {
            oRMetadata.process(this.m_session, classLoader);
        }
        for (NamedQueryMetadata namedQueryMetadata : this.m_queries.values()) {
            namedQueryMetadata.process(this.m_session, classLoader);
        }
    }

    protected void processRelationshipAccessors() {
        for (RelationshipAccessor relationshipAccessor : this.m_relationshipAccessors) {
            relationshipAccessor.processRelationship();
        }
    }

    protected void processSequencingAccessors() {
        if (!this.m_generatedValues.isEmpty()) {
            TableSequence tableSequence;
            Object object;
            Object object2;
            Object object3;
            DatabaseLogin databaseLogin = this.m_session.getProject().getLogin();
            Object object5 = null;
            TableSequence tableSequence2 = new TableSequence(DEFAULT_TABLE_GENERATOR);
            Object object6 = new NativeSequence(DEFAULT_SEQUENCE_GENERATOR, false);
            NativeSequence nativeSequence = new NativeSequence(DEFAULT_IDENTITY_GENERATOR, 1, true);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            for (SequenceGeneratorMetadata object7 : this.m_sequenceGenerators.values()) {
                String string = object7.getName();
                object3 = object7.getSequenceName() != null && !object7.getSequenceName().equals("") ? object7.getSequenceName() : string;
                object2 = object7.getAllocationSize();
                if (object2 == null) {
                    object2 = new Integer(50);
                }
                object = new NativeSequence((String)object3, ((Integer)object2).intValue(), false);
                hashtable.put(string, object);
                if (string.equals(DEFAULT_AUTO_GENERATOR)) {
                    object5 = object;
                    continue;
                }
                if (!string.equals(DEFAULT_SEQUENCE_GENERATOR)) continue;
                object6 = object;
            }
            for (TableGeneratorMetadata tableGeneratorMetadata : this.m_tableGenerators.values()) {
                String string = tableGeneratorMetadata.getGeneratorName();
                object3 = tableGeneratorMetadata.getPkColumnValue() != null && !tableGeneratorMetadata.getPkColumnValue().equals("") ? tableGeneratorMetadata.getPkColumnValue() : string;
                object2 = tableGeneratorMetadata.getAllocationSize();
                if (object2 == null) {
                    object2 = new Integer(50);
                }
                if ((object = tableGeneratorMetadata.getInitialValue()) == null) {
                    object = new Integer(0);
                }
                tableSequence = new TableSequence((String)object3, ((Integer)object2).intValue(), ((Integer)object).intValue());
                hashtable.put(string, tableSequence);
                tableSequence.setTable(tableGeneratorMetadata.getDatabaseTable());
                if (tableGeneratorMetadata.getPkColumnName() != null && !tableGeneratorMetadata.getPkColumnName().equals("")) {
                    tableSequence.setNameFieldName(tableGeneratorMetadata.getPkColumnName());
                }
                if (tableGeneratorMetadata.getValueColumnName() != null && !tableGeneratorMetadata.getValueColumnName().equals("")) {
                    tableSequence.setCounterFieldName(tableGeneratorMetadata.getValueColumnName());
                }
                if (string.equals(DEFAULT_AUTO_GENERATOR)) {
                    object5 = tableSequence;
                    continue;
                }
                if (!string.equals(DEFAULT_TABLE_GENERATOR)) continue;
                tableSequence2 = tableSequence;
            }
            boolean bl = false;
            for (Class clazz : this.m_generatedValues.keySet()) {
                Object object4;
                object3 = this.m_allAccessors.get(clazz.getName()).getDescriptor();
                object2 = this.m_generatedValues.get(clazz);
                object = ((GeneratedValueMetadata)object2).getGenerator();
                if (object == null) {
                    object = "";
                }
                tableSequence = null;
                if (!((String)object).equals("")) {
                    tableSequence = (Sequence)hashtable.get(object);
                }
                if (tableSequence == null) {
                    object4 = ((GeneratedValueMetadata)object2).getStrategy();
                    if (object4 == null || ((Enum)object4).name().equals(GenerationType.AUTO.name())) {
                        bl = true;
                    } else if (((Enum)object4).name().equals(GenerationType.TABLE.name())) {
                        if (((String)object).equals("")) {
                            tableSequence = tableSequence2;
                        } else {
                            tableSequence = (Sequence)tableSequence2.clone();
                            tableSequence.setName((String)object);
                        }
                    } else if (((Enum)object4).name().equals(GenerationType.SEQUENCE.name())) {
                        if (((String)object).equals("")) {
                            tableSequence = object6;
                        } else {
                            tableSequence = (Sequence)object6.clone();
                            tableSequence.setName((String)object);
                        }
                    } else if (((Enum)object4).name().equals(GenerationType.IDENTITY.name())) {
                        if (((String)object).equals("")) {
                            tableSequence = nativeSequence;
                        } else {
                            tableSequence = (Sequence)nativeSequence.clone();
                            tableSequence.setName((String)object);
                        }
                    }
                }
                if (tableSequence != null) {
                    ((MetadataDescriptor)object3).setSequenceNumberName(tableSequence.getName());
                    databaseLogin.addSequence((Sequence)tableSequence);
                    continue;
                }
                object4 = ((String)object).equals("") ? (object5 != null ? object5.getName() : DEFAULT_AUTO_GENERATOR) : object;
                ((MetadataDescriptor)object3).setSequenceNumberName((String)object4);
            }
            if (bl && object5 != null) {
                databaseLogin.setDefaultSequence(object5);
            }
        }
    }

    public void processStage1() {
        for (EntityAccessor entityAccessor : this.getEntityAccessors()) {
            if (entityAccessor.isPreProcessed()) continue;
            entityAccessor.preProcess();
        }
    }

    public void processStage2() {
        for (EntityAccessor entityAccessor : this.getEntityAccessors()) {
            if (entityAccessor.isProcessed()) continue;
            entityAccessor.process();
        }
    }

    public void processStage3() {
        this.processAccessorsWithDerivedIDs();
        this.processDirectCollectionAccessors();
        this.processSequencingAccessors();
        this.processRelationshipAccessors();
        this.processInterfaceAccessors();
        this.processEmbeddableMappingAccessors();
    }

    public void processTable(TableMetadata tableMetadata, String string, String string2, String string3) {
        String string4 = MetadataHelper.getName(tableMetadata.getName(), string, tableMetadata.getNameContext(), this.m_logger, tableMetadata.getLocation());
        String string5 = MetadataHelper.getName(tableMetadata.getCatalog(), string2, tableMetadata.getCatalogContext(), this.m_logger, tableMetadata.getLocation());
        String string6 = MetadataHelper.getName(tableMetadata.getSchema(), string3, tableMetadata.getSchemaContext(), this.m_logger, tableMetadata.getLocation());
        String string7 = new String(string4);
        if (!string6.equals("")) {
            string7 = string6 + "." + string7;
        }
        if (!string5.equals("")) {
            string7 = string5 + "." + string7;
        }
        tableMetadata.setFullyQualifiedTableName(string7);
        tableMetadata.processUniqueConstraints();
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata xMLPersistenceUnitMetadata) {
        if (this.m_persistenceUnitMetadata == null) {
            this.m_persistenceUnitMetadata = xMLPersistenceUnitMetadata;
        } else {
            this.m_persistenceUnitMetadata.merge(xMLPersistenceUnitMetadata);
        }
    }

    public void setWeavingEnabled(boolean bl) {
        this.m_weavingEnabled = bl;
    }

    public boolean weaveEager() {
        return this.m_weaveEager;
    }
}

