/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.Table;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.InheritanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.SecondaryTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAccessor
extends MappedSuperclassAccessor {
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private InheritanceMetadata m_inheritance;
    private List<AssociationOverrideMetadata> m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
    private List<NamedQueryMetadata> m_namedQueries = new ArrayList<NamedQueryMetadata>();
    private List<NamedNativeQueryMetadata> m_namedNativeQueries = new ArrayList<NamedNativeQueryMetadata>();
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries = new ArrayList<NamedStoredProcedureQueryMetadata>();
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings = new ArrayList<SQLResultSetMappingMetadata>();
    private List<SecondaryTableMetadata> m_secondaryTables = new ArrayList<SecondaryTableMetadata>();
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    private ArrayList<MappedSuperclassAccessor> m_mappedSuperclasses = new ArrayList();
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private String m_discriminatorValue;
    private String m_entityName;
    private TableGeneratorMetadata m_tableGenerator;
    private TableMetadata m_table;

    public EntityAccessor() {
        super("<entity>");
    }

    public EntityAccessor(Annotation annotation, Class clazz, MetadataProject metadataProject) {
        super(annotation, clazz, metadataProject);
    }

    protected void addMultipleTableKeyFields(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumnsMetadata, DatabaseTable databaseTable, DatabaseTable databaseTable2, String string, String string2) {
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumnMetadata : this.processPrimaryKeyJoinColumns(primaryKeyJoinColumnsMetadata)) {
            String string3 = this.getDescriptor().getPrimaryKeyFieldName();
            DatabaseField databaseField = primaryKeyJoinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, string3, string));
            databaseField.setTable(databaseTable);
            DatabaseField databaseField2 = primaryKeyJoinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, databaseField.getName(), string2));
            databaseField2.setTable(databaseTable2);
            this.getDescriptor().addForeignKeyFieldForMultipleTable(databaseField2, databaseField);
        }
    }

    protected void addPotentialMappedSuperclass(Class clazz) {
        MappedSuperclassAccessor mappedSuperclassAccessor = this.getProject().getMappedSuperclass(clazz);
        if (mappedSuperclassAccessor == null) {
            MetadataClass metadataClass = new MetadataClass(clazz);
            if (metadataClass.isAnnotationPresent(MappedSuperclass.class)) {
                this.m_mappedSuperclasses.add(new MappedSuperclassAccessor((Annotation)metadataClass.getAnnotation(MappedSuperclass.class), clazz, this.getDescriptor()));
            }
        } else {
            this.m_mappedSuperclasses.add(this.reloadMappedSuperclass(mappedSuperclassAccessor, this.getDescriptor()));
        }
    }

    protected void clearMappedSuperclassesAndInheritanceParents() {
        if (!this.m_mappedSuperclasses.isEmpty()) {
            this.m_mappedSuperclasses.clear();
        }
        this.getDescriptor().setInheritanceParentDescriptor(null);
        this.getDescriptor().setInheritanceRootDescriptor(null);
    }

    protected void discoverMappedSuperclassesAndInheritanceParents() {
        Class clazz;
        this.clearMappedSuperclassesAndInheritanceParents();
        EntityAccessor entityAccessor = this;
        Object object = this;
        Type type = this.getJavaClass().getGenericSuperclass();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        if (clazz != Object.class) {
            for (clazz = this.getJavaClass().getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                EntityAccessor entityAccessor2 = this.getProject().getEntityAccessor(clazz.getName());
                if (entityAccessor2 != null) {
                    ((MetadataAccessor)object).getDescriptor().setInheritanceParentDescriptor(entityAccessor2.getDescriptor());
                    entityAccessor = object;
                    object = entityAccessor2;
                    ((EntityAccessor)object).clearMappedSuperclassesAndInheritanceParents();
                    if (((EntityAccessor)object).hasInheritance()) {
                        for (EntityAccessor entityAccessor3 : arrayList) {
                            entityAccessor3.getDescriptor().setInheritanceRootDescriptor(((MetadataAccessor)object).getDescriptor());
                        }
                        arrayList.clear();
                    }
                    arrayList.add(object);
                    ((EntityAccessor)object).resolveGenericTypes(type, entityAccessor.getDescriptor());
                } else {
                    ((EntityAccessor)object).addPotentialMappedSuperclass(clazz);
                    ((EntityAccessor)object).resolveGenericTypes(type, ((MetadataAccessor)object).getDescriptor());
                }
                type = clazz.getGenericSuperclass();
            }
        } else {
            ((EntityAccessor)object).resolveGenericTypes(type, ((MetadataAccessor)object).getDescriptor());
        }
        if (!arrayList.isEmpty()) {
            for (Object object2 : arrayList) {
                if (object2 == object) continue;
                ((MetadataAccessor)object2).getDescriptor().setInheritanceRootDescriptor(((MetadataAccessor)object).getDescriptor());
            }
        }
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public String getDiscriminatorValue() {
        return this.m_discriminatorValue;
    }

    public String getDiscriminatorValueOrNull() {
        if (!Modifier.isAbstract(this.getJavaClass().getModifiers())) {
            if (this.m_discriminatorValue == null) {
                Object t = this.getAnnotation(DiscriminatorValue.class);
                if (t == null) {
                    return Helper.getShortClassName((String)this.getJavaClassName());
                }
                return (String)MetadataHelper.invokeMethod("value", t);
            }
            return this.m_discriminatorValue;
        }
        return null;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public InheritanceMetadata getInheritance() {
        return this.m_inheritance;
    }

    public ArrayList<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    public List<SecondaryTableMetadata> getSecondaryTables() {
        return this.m_secondaryTables;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public TableMetadata getTable() {
        return this.m_table;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    public boolean hasInheritance() {
        if (this.m_inheritance == null) {
            return this.isAnnotationPresent(Inheritance.class);
        }
        return true;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_inheritance, metadataAccessibleObject);
        this.initXMLObject(this.m_discriminatorColumn, metadataAccessibleObject);
        this.initXMLObject(this.m_sequenceGenerator, metadataAccessibleObject);
        this.initXMLObject(this.m_tableGenerator, metadataAccessibleObject);
        this.initXMLObject(this.m_table, metadataAccessibleObject);
        this.initXMLObjects(this.m_associationOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_namedQueries, metadataAccessibleObject);
        this.initXMLObjects(this.m_namedNativeQueries, metadataAccessibleObject);
        this.initXMLObjects(this.m_namedStoredProcedureQueries, metadataAccessibleObject);
        this.initXMLObjects(this.m_sqlResultSetMappings, metadataAccessibleObject);
        this.initXMLObjects(this.m_secondaryTables, metadataAccessibleObject);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, metadataAccessibleObject);
    }

    @Override
    public boolean isMappedSuperclass() {
        return false;
    }

    @Override
    public void merge(ORMetadata oRMetadata) {
        super.merge(oRMetadata);
        EntityAccessor entityAccessor = (EntityAccessor)oRMetadata;
        this.m_entityName = (String)this.mergeSimpleObjects(this.m_entityName, entityAccessor.getEntityName(), entityAccessor.getAccessibleObject(), "@name");
        this.m_discriminatorValue = (String)this.mergeSimpleObjects(this.m_discriminatorValue, entityAccessor.getDiscriminatorValue(), entityAccessor.getAccessibleObject(), "<discriminator-value>");
        this.m_discriminatorColumn = (DiscriminatorColumnMetadata)this.mergeORObjects(this.m_discriminatorColumn, entityAccessor.getDiscriminatorColumn());
        this.m_inheritance = (InheritanceMetadata)this.mergeORObjects(this.m_inheritance, entityAccessor.getInheritance());
        this.m_sequenceGenerator = (SequenceGeneratorMetadata)this.mergeORObjects(this.m_sequenceGenerator, entityAccessor.getSequenceGenerator());
        this.m_tableGenerator = (TableGeneratorMetadata)this.mergeORObjects(this.m_tableGenerator, entityAccessor.getTableGenerator());
        this.m_table = (TableMetadata)this.mergeORObjects(this.m_table, entityAccessor.getTable());
        this.m_namedQueries = this.mergeORObjectLists(this.m_namedQueries, entityAccessor.getNamedQueries());
        this.m_namedNativeQueries = this.mergeORObjectLists(this.m_namedNativeQueries, entityAccessor.getNamedNativeQueries());
        this.m_namedStoredProcedureQueries = this.mergeORObjectLists(this.m_namedStoredProcedureQueries, entityAccessor.getNamedStoredProcedureQueries());
        this.m_sqlResultSetMappings = this.mergeORObjectLists(this.m_sqlResultSetMappings, entityAccessor.getSqlResultSetMappings());
        this.m_associationOverrides = this.mergeORObjectLists(this.m_associationOverrides, entityAccessor.getAssociationOverrides());
        this.m_attributeOverrides = this.mergeORObjectLists(this.m_attributeOverrides, entityAccessor.getAttributeOverrides());
        this.m_secondaryTables = this.mergeORObjectLists(this.m_secondaryTables, entityAccessor.getSecondaryTables());
        this.m_primaryKeyJoinColumns = this.mergeORObjectLists(this.m_primaryKeyJoinColumns, entityAccessor.getPrimaryKeyJoinColumns());
    }

    @Override
    public void preProcess() {
        Object object;
        this.setIsPreProcessed();
        if (!this.getDescriptor().isInheritanceSubclass()) {
            this.discoverMappedSuperclassesAndInheritanceParents();
        }
        if (this.getDescriptor().isInheritanceSubclass() && !((ClassAccessor)(object = this.getDescriptor().getInheritanceParentDescriptor().getClassAccessor())).isPreProcessed()) {
            ((ClassAccessor)object).preProcess();
        }
        this.processEntity();
        for (MappedSuperclassAccessor mappedSuperclassAccessor : this.m_mappedSuperclasses) {
            mappedSuperclassAccessor.preProcess();
        }
        this.addAccessors();
        this.addConverters();
    }

    @Override
    public void process() {
        Object object;
        this.setIsProcessed();
        if (this.getDescriptor().isInheritanceSubclass() && !((ClassAccessor)(object = this.getDescriptor().getInheritanceParentDescriptor().getClassAccessor())).isProcessed()) {
            ((ClassAccessor)object).process();
        }
        this.processTableAndInheritance();
        this.processClassMetadata();
        for (MappedSuperclassAccessor mappedSuperclassAccessor : this.m_mappedSuperclasses) {
            mappedSuperclassAccessor.process();
        }
        this.processAccessors();
    }

    @Override
    protected void processAssociationOverrides() {
        for (AssociationOverrideMetadata associationOverrideMetadata : this.m_associationOverrides) {
            this.processAssociationOverride(associationOverrideMetadata);
        }
        super.processAssociationOverrides();
    }

    @Override
    protected void processAttributeOverrides() {
        for (AttributeOverrideMetadata attributeOverrideMetadata : this.m_attributeOverrides) {
            this.processAttributeOverride(attributeOverrideMetadata);
        }
        super.processAttributeOverrides();
    }

    @Override
    public void processDerivedIDs(HashSet<ClassAccessor> hashSet, HashSet<ClassAccessor> hashSet2) {
        if (this.hasDerivedId() && !hashSet2.contains(this)) {
            super.processDerivedIDs(hashSet, hashSet2);
            this.validatePrimaryKey();
            this.processSecondaryTables();
        }
    }

    public DatabaseField processDiscriminatorColumn() {
        if (this.m_discriminatorColumn == null) {
            this.m_discriminatorColumn = new DiscriminatorColumnMetadata((Annotation)this.getAnnotation(DiscriminatorColumn.class), this.getAccessibleObject());
        }
        return this.m_discriminatorColumn.process(this.getDescriptor(), this.getAnnotatedElementName(), "metadata_default_inheritance_discriminator_column");
    }

    @Override
    public void processAccessors() {
        super.processAccessors();
        this.validateOptimisticLocking();
        if (!this.hasDerivedId()) {
            this.validatePrimaryKey();
            this.processSecondaryTables();
        }
    }

    protected void processAccessType() {
        String string = this.getAccess();
        String string2 = null;
        if (this.getDescriptor().isInheritanceSubclass()) {
            for (Object object = this.getDescriptor().getInheritanceParentDescriptor(); object != null; object = ((MetadataDescriptor)object).getInheritanceParentDescriptor()) {
                if (((MetadataDescriptor)object).getClassAccessor().hasAccess()) continue;
                string2 = ((MetadataDescriptor)object).getDefaultAccess();
                break;
            }
        }
        if (string2 == null) {
            for (MappedSuperclassAccessor mappedSuperclassAccessor : this.m_mappedSuperclasses) {
                if (mappedSuperclassAccessor.hasAccess()) continue;
                if (this.havePersistenceAnnotationsDefined(MetadataHelper.getFields(mappedSuperclassAccessor.getJavaClass()))) {
                    string2 = "FIELD";
                    break;
                }
                if (!this.havePersistenceAnnotationsDefined(MetadataHelper.getDeclaredMethods(mappedSuperclassAccessor.getJavaClass()))) break;
                string2 = "PROPERTY";
                break;
            }
            if (string2 == null) {
                string2 = this.havePersistenceAnnotationsDefined(MetadataHelper.getFields(this.getJavaClass())) ? "FIELD" : (this.havePersistenceAnnotationsDefined(MetadataHelper.getDeclaredMethods(this.getJavaClass())) ? "PROPERTY" : (this.getDescriptor().getDefaultAccess() != null ? this.getDescriptor().getDefaultAccess() : "FIELD"));
            }
        }
        this.getDescriptor().setDefaultAccess(string2);
        if (string == null) {
            this.getLogger().logConfigMessage("metadata_access_type", string2, (Object)this.getJavaClass());
        }
    }

    protected void processEntity() {
        this.processAccessType();
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        } else {
            for (MappedSuperclassAccessor mappedSuperclassAccessor : this.m_mappedSuperclasses) {
                if (mappedSuperclassAccessor.getMetadataComplete() == null) continue;
                this.getDescriptor().setIgnoreAnnotations(mappedSuperclassAccessor.isMetadataComplete());
                break;
            }
        }
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        } else {
            for (MappedSuperclassAccessor mappedSuperclassAccessor : this.m_mappedSuperclasses) {
                if (mappedSuperclassAccessor.getExcludeDefaultMappings() == null) continue;
                this.getDescriptor().setIgnoreDefaultMappings(mappedSuperclassAccessor.excludeDefaultMappings());
                break;
            }
        }
        if (this.m_entityName == null) {
            String string = this.m_entityName = this.getAnnotation(Entity.class) == null ? "" : (String)MetadataHelper.invokeMethod("name", this.getAnnotation(Entity.class));
        }
        if (this.m_entityName.equals("")) {
            this.m_entityName = Helper.getShortClassName((String)this.getJavaClassName());
            this.getLogger().logConfigMessage("metadata_default_alias", this.getDescriptor(), (Object)this.m_entityName);
        }
        this.getProject().addAlias(this.m_entityName, this.getDescriptor());
    }

    protected void processInheritance() {
        if (this.m_inheritance == null) {
            this.m_inheritance = new InheritanceMetadata((Annotation)this.getAnnotation(Inheritance.class), this.getAccessibleObject());
        }
        this.m_inheritance.process(this.getDescriptor());
    }

    public void processInheritancePrimaryKeyJoinColumns() {
        PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumnsMetadata;
        if (this.m_primaryKeyJoinColumns.isEmpty()) {
            Object t = this.getAnnotation(PrimaryKeyJoinColumn.class);
            Object t2 = this.getAnnotation(PrimaryKeyJoinColumns.class);
            primaryKeyJoinColumnsMetadata = new PrimaryKeyJoinColumnsMetadata((Annotation)t2, (Annotation)t, this.getAccessibleObject());
        } else {
            primaryKeyJoinColumnsMetadata = new PrimaryKeyJoinColumnsMetadata(this.m_primaryKeyJoinColumns);
        }
        this.addMultipleTableKeyFields(primaryKeyJoinColumnsMetadata, this.getDescriptor().getPrimaryKeyTable(), this.getDescriptor().getPrimaryTable(), "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column");
    }

    public void processListeners(ClassLoader classLoader) {
        for (EntityListenerMetadata entityListenerMetadata : this.getProject().getDefaultListeners()) {
            ((EntityListenerMetadata)entityListenerMetadata.clone()).process(this.getDescriptor(), classLoader, true);
        }
        this.discoverMappedSuperclassesAndInheritanceParents();
        if (!this.getDescriptor().excludeSuperclassListeners()) {
            int n = this.m_mappedSuperclasses.size();
            for (int i = n - 1; i >= 0; --i) {
                this.m_mappedSuperclasses.get(i).processEntityListeners(classLoader);
            }
        }
        this.processEntityListeners(classLoader);
        new EntityClassListenerMetadata(this).process(this.m_mappedSuperclasses);
    }

    @Override
    protected void processNamedNativeQueries() {
        for (NamedNativeQueryMetadata namedNativeQueryMetadata : this.m_namedNativeQueries) {
            this.getProject().addQuery(namedNativeQueryMetadata);
        }
        super.processNamedNativeQueries();
    }

    @Override
    protected void processNamedQueries() {
        for (NamedQueryMetadata namedQueryMetadata : this.m_namedQueries) {
            this.getProject().addQuery(namedQueryMetadata);
        }
        super.processNamedQueries();
    }

    @Override
    protected void processNamedStoredProcedureQueries() {
        for (NamedStoredProcedureQueryMetadata namedStoredProcedureQueryMetadata : this.m_namedStoredProcedureQueries) {
            this.getProject().addQuery(namedStoredProcedureQueryMetadata);
        }
        super.processNamedStoredProcedureQueries();
    }

    protected void processSecondaryTable(SecondaryTableMetadata secondaryTableMetadata) {
        this.processTable(secondaryTableMetadata, secondaryTableMetadata.getName());
        this.getDescriptor().addTable(secondaryTableMetadata.getDatabaseTable());
        this.addMultipleTableKeyFields(new PrimaryKeyJoinColumnsMetadata(secondaryTableMetadata.getPrimaryKeyJoinColumns()), this.getDescriptor().getPrimaryTable(), secondaryTableMetadata.getDatabaseTable(), "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column");
    }

    protected void processSecondaryTables() {
        block6: {
            Object t;
            Object t2;
            block4: {
                block5: {
                    t2 = this.getAnnotation(SecondaryTable.class);
                    t = this.getAnnotation(SecondaryTables.class);
                    if (!this.m_secondaryTables.isEmpty()) break block4;
                    if (t == null) break block5;
                    for (Annotation annotation : (Annotation[])MetadataHelper.invokeMethod("value", t)) {
                        this.processSecondaryTable(new SecondaryTableMetadata(annotation, this.getAccessibleObject()));
                    }
                    break block6;
                }
                if (t2 == null) break block6;
                this.processSecondaryTable(new SecondaryTableMetadata((Annotation)t2, this.getAccessibleObject()));
                break block6;
            }
            if (t2 != null) {
                this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t2, this.getJavaClassName(), this.getLocation());
            }
            if (t != null) {
                this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t, this.getJavaClassName(), this.getLocation());
            }
            for (SecondaryTableMetadata secondaryTableMetadata : this.m_secondaryTables) {
                this.processSecondaryTable(secondaryTableMetadata);
            }
        }
    }

    @Override
    protected void processSequenceGenerator() {
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator);
        }
        super.processSequenceGenerator();
    }

    @Override
    protected void processSqlResultSetMappings() {
        for (SQLResultSetMappingMetadata sQLResultSetMappingMetadata : this.m_sqlResultSetMappings) {
            this.getProject().addSQLResultSetMapping(sQLResultSetMappingMetadata);
        }
        super.processSqlResultSetMappings();
    }

    protected void processTable() {
        Object t = this.getAnnotation(Table.class);
        if (this.m_table == null) {
            this.processTable(new TableMetadata((Annotation)t, this.getAccessibleObject()));
        } else {
            if (t != null) {
                this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t, this.getJavaClassName(), this.getLocation());
            }
            this.processTable(this.m_table);
        }
    }

    protected void processTable(TableMetadata tableMetadata) {
        this.processTable(tableMetadata, this.getDescriptor().getDefaultTableName());
        this.getDescriptor().setPrimaryTable(tableMetadata.getDatabaseTable());
    }

    protected void processTableAndInheritance() {
        if (this.getDescriptor().isInheritanceSubclass()) {
            MetadataDescriptor metadataDescriptor = this.getDescriptor().getInheritanceRootDescriptor();
            EntityAccessor entityAccessor = (EntityAccessor)metadataDescriptor.getClassAccessor();
            if (!entityAccessor.hasInheritance()) {
                entityAccessor.processInheritance();
            }
            if (this.hasInheritance() || !metadataDescriptor.usesSingleTableInheritanceStrategy()) {
                this.processTable();
            }
            if (this.hasInheritance()) {
                this.processInheritance();
            } else {
                entityAccessor.getInheritance().process(this.getDescriptor());
            }
        } else {
            this.processTable();
            if (this.hasInheritance()) {
                this.processInheritance();
            }
        }
    }

    @Override
    protected void processTableGenerator() {
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        super.processTableGenerator();
    }

    protected void resolveGenericTypes(Type type, MetadataDescriptor metadataDescriptor) {
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = ((Class)((ParameterizedType)type).getRawType()).getTypeParameters();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type2 = typeArray[i];
                TypeVariable typeVariable = typeVariableArray[i];
                if (type2 instanceof TypeVariable) {
                    this.getDescriptor().addGenericType(typeVariable.getName(), metadataDescriptor.getGenericType(((TypeVariable)type2).getName()));
                    continue;
                }
                this.getDescriptor().addGenericType(typeVariable.getName(), type2);
            }
        }
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> list) {
        this.m_associationOverrides = list;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> list) {
        this.m_attributeOverrides = list;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumnMetadata) {
        this.m_discriminatorColumn = discriminatorColumnMetadata;
    }

    public void setDiscriminatorValue(String string) {
        this.m_discriminatorValue = string;
    }

    public void setEntityName(String string) {
        this.m_entityName = string;
    }

    public void setInheritance(InheritanceMetadata inheritanceMetadata) {
        this.m_inheritance = inheritanceMetadata;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> list) {
        this.m_primaryKeyJoinColumns = list;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> list) {
        this.m_namedNativeQueries = list;
    }

    public void setNamedQueries(List<NamedQueryMetadata> list) {
        this.m_namedQueries = list;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> list) {
        this.m_namedStoredProcedureQueries = list;
    }

    public void setSecondaryTables(List<SecondaryTableMetadata> list) {
        this.m_secondaryTables = list;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGeneratorMetadata) {
        this.m_sequenceGenerator = sequenceGeneratorMetadata;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> list) {
        this.m_sqlResultSetMappings = list;
    }

    public void setTable(TableMetadata tableMetadata) {
        this.m_table = tableMetadata;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGeneratorMetadata) {
        this.m_tableGenerator = tableGeneratorMetadata;
    }

    protected void validateOptimisticLocking() {
        if (this.getDescriptor().usesVersionColumnOptimisticLocking() && !this.getDescriptor().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingVersionElementNotSpecified((Class)this.getJavaClass());
        }
    }

    protected void validatePrimaryKey() {
        if (this.getDescriptor().hasCompositePrimaryKey()) {
            if (this.getDescriptor().pkClassWasNotValidated()) {
                throw ValidationException.invalidCompositePKSpecification((Class)this.getJavaClass(), (String)this.getDescriptor().getPKClassName());
            }
        } else if (!this.getDescriptor().hasPrimaryKeyFields() && !this.getDescriptor().isInheritanceSubclass()) {
            throw ValidationException.noPrimaryKeyAnnotationsFound((Class)this.getJavaClass());
        }
    }
}

