/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.columns.OverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationOverrideMetadata
extends OverrideMetadata {
    private JoinTableMetadata m_joinTable;
    private List<JoinColumnMetadata> m_joinColumns;

    public AssociationOverrideMetadata() {
        super("<association-override>");
    }

    public AssociationOverrideMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("joinColumns", annotation)) {
            this.m_joinColumns.add(new JoinColumnMetadata(annotation2, metadataAccessibleObject));
        }
        this.m_joinTable = new JoinTableMetadata((Annotation)MetadataHelper.invokeMethod("joinTable", annotation), metadataAccessibleObject);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof AssociationOverrideMetadata) {
            AssociationOverrideMetadata associationOverrideMetadata = (AssociationOverrideMetadata)object;
            if (!this.valuesMatch(this.m_joinColumns, associationOverrideMetadata.getJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_joinTable, associationOverrideMetadata.getJoinTable());
        }
        return false;
    }

    @Override
    public String getIgnoreMappedSuperclassContext() {
        return "metadata_warning_ignore_mapped_superclass_association_override";
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    public boolean hasJoinColumns() {
        return !this.m_joinColumns.isEmpty();
    }

    public void setJoinColumns(List<JoinColumnMetadata> list) {
        this.m_joinColumns = list;
    }

    public void setJoinTable(JoinTableMetadata joinTableMetadata) {
        this.m_joinTable = joinTableMetadata;
    }
}

