/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public class ColumnMetadata
extends ORMetadata {
    private Boolean m_unique;
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;
    private DatabaseField m_databaseField;
    private Integer m_scale;
    private Integer m_length;
    private Integer m_precision;
    private String m_attributeName;
    private String m_name;
    private String m_table;
    private String m_columnDefinition;

    public ColumnMetadata() {
        super("<column>");
    }

    public ColumnMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        this(annotation, metadataAccessibleObject, "");
    }

    public ColumnMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, String string) {
        super(annotation, metadataAccessibleObject);
        this.m_attributeName = string;
        if (annotation != null) {
            this.setUnique((Boolean)MetadataHelper.invokeMethod("unique", annotation));
            this.setNullable((Boolean)MetadataHelper.invokeMethod("nullable", annotation));
            this.setUpdatable((Boolean)MetadataHelper.invokeMethod("updatable", annotation));
            this.setInsertable((Boolean)MetadataHelper.invokeMethod("insertable", annotation));
            this.setScale((Integer)MetadataHelper.invokeMethod("scale", annotation));
            this.setLength((Integer)MetadataHelper.invokeMethod("length", annotation));
            this.setPrecision((Integer)MetadataHelper.invokeMethod("precision", annotation));
            this.setName((String)MetadataHelper.invokeMethod("name", annotation));
            this.setTable((String)MetadataHelper.invokeMethod("table", annotation));
            this.setColumnDefinition((String)MetadataHelper.invokeMethod("columnDefinition", annotation));
        }
    }

    public ColumnMetadata(MetadataAccessibleObject metadataAccessibleObject, String string) {
        this(null, metadataAccessibleObject, string);
    }

    public boolean equals(Object object) {
        if (object instanceof ColumnMetadata) {
            ColumnMetadata columnMetadata = (ColumnMetadata)object;
            if (!this.valuesMatch(this.m_unique, columnMetadata.getUnique())) {
                return false;
            }
            if (!this.valuesMatch(this.m_nullable, columnMetadata.getNullable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_updatable, columnMetadata.getUpdatable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_insertable, columnMetadata.getInsertable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_scale, columnMetadata.getScale())) {
                return false;
            }
            if (!this.valuesMatch(this.m_length, columnMetadata.getLength())) {
                return false;
            }
            if (!this.valuesMatch(this.m_precision, columnMetadata.getPrecision())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, columnMetadata.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_table, columnMetadata.getTable())) {
                return false;
            }
            return this.valuesMatch(this.m_columnDefinition, columnMetadata.getColumnDefinition());
        }
        return false;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public DatabaseField getDatabaseField() {
        if (this.m_databaseField == null) {
            this.m_databaseField = new DatabaseField();
            this.m_databaseField.setUnique(this.m_unique == null ? false : this.m_unique);
            this.m_databaseField.setNullable(this.m_nullable == null ? true : this.m_nullable);
            this.m_databaseField.setUpdatable(this.m_updatable == null ? true : this.m_updatable);
            this.m_databaseField.setInsertable(this.m_insertable == null ? true : this.m_insertable);
            this.m_databaseField.setScale(this.m_scale == null ? 0 : this.m_scale);
            this.m_databaseField.setLength(this.m_length == null ? 255 : this.m_length);
            this.m_databaseField.setPrecision(this.m_precision == null ? 0 : this.m_precision);
            this.m_databaseField.setName(this.m_name == null ? "" : this.m_name);
            this.m_databaseField.setTableName(this.m_table == null ? "" : this.m_table);
            this.m_databaseField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        }
        return this.m_databaseField;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public String getUpperCaseAttributeName() {
        return this.m_attributeName.toUpperCase();
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_attributeName = metadataAccessibleObject.getAttributeName();
    }

    public void setAttributeName(String string) {
        this.m_attributeName = string;
    }

    public void setColumnDefinition(String string) {
        this.m_columnDefinition = string;
    }

    public void setDatabaseField(DatabaseField databaseField) {
        this.m_databaseField = databaseField;
    }

    public void setInsertable(Boolean bl) {
        this.m_insertable = bl;
    }

    public void setLength(Integer n) {
        this.m_length = n;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setNullable(Boolean bl) {
        this.m_nullable = bl;
    }

    public void setPrecision(Integer n) {
        this.m_precision = n;
    }

    public void setScale(Integer n) {
        this.m_scale = n;
    }

    public void setTable(String string) {
        this.m_table = string;
    }

    public void setUnique(Boolean bl) {
        this.m_unique = bl;
    }

    public void setUpdatable(Boolean bl) {
        this.m_updatable = bl;
    }
}

