/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sequencing;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

public class TableGeneratorMetadata
extends TableMetadata {
    private Integer m_allocationSize;
    private Integer m_initialValue;
    private String m_generatorName;
    private String m_pkColumnValue;
    private String m_pkColumnName;
    private String m_valueColumnName;

    protected TableGeneratorMetadata() {
        super("<table-generator>");
    }

    public TableGeneratorMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_allocationSize = (Integer)MetadataHelper.invokeMethod("allocationSize", annotation);
        this.m_initialValue = (Integer)MetadataHelper.invokeMethod("initialValue", annotation);
        this.m_generatorName = (String)MetadataHelper.invokeMethod("name", annotation);
        this.m_pkColumnName = (String)MetadataHelper.invokeMethod("pkColumnName", annotation);
        this.m_pkColumnValue = (String)MetadataHelper.invokeMethod("pkColumnValue", annotation);
        this.m_valueColumnName = (String)MetadataHelper.invokeMethod("valueColumnName", annotation);
        this.setName((String)MetadataHelper.invokeMethod("table", annotation));
    }

    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof TableGeneratorMetadata) {
            TableGeneratorMetadata tableGeneratorMetadata = (TableGeneratorMetadata)object;
            if (!this.valuesMatch(this.m_allocationSize, tableGeneratorMetadata.getAllocationSize())) {
                return false;
            }
            if (!this.valuesMatch(this.m_initialValue, tableGeneratorMetadata.getInitialValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_generatorName, tableGeneratorMetadata.getGeneratorName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_pkColumnValue, tableGeneratorMetadata.getPkColumnValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_pkColumnName, tableGeneratorMetadata.getPkColumnName())) {
                return false;
            }
            return this.valuesMatch(this.m_valueColumnName, tableGeneratorMetadata.getValueColumnName());
        }
        return false;
    }

    public Integer getAllocationSize() {
        return this.m_allocationSize;
    }

    public String getCatalogContext() {
        return "metadata_default_table_generator_catalog";
    }

    public String getGeneratorName() {
        return this.m_generatorName;
    }

    public String getIdentifier() {
        return this.m_generatorName;
    }

    public Integer getInitialValue() {
        return this.m_initialValue;
    }

    public String getNameContext() {
        return "metadata_default_table_generator_name";
    }

    public String getPkColumnName() {
        return this.m_pkColumnName;
    }

    public String getPkColumnValue() {
        return this.m_pkColumnValue;
    }

    public String getSchemaContext() {
        return "metadata_default_table_generator_schema";
    }

    public String getValueColumnName() {
        return this.m_valueColumnName;
    }

    public void setAllocationSize(Integer n) {
        this.m_allocationSize = n;
    }

    public void setGeneratorName(String string) {
        this.m_generatorName = string;
    }

    public void setInitialValue(Integer n) {
        this.m_initialValue = n;
    }

    public void setPkColumnName(String string) {
        this.m_pkColumnName = string;
    }

    public void setPkColumnValue(String string) {
        this.m_pkColumnValue = string;
    }

    public void setValueColumnName(String string) {
        this.m_valueColumnName = string;
    }
}

