/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;

public class StaticWeave {
    private String[] argv;
    private String source;
    private String persistenceinfopath;
    private String target;
    private int loglevel = 8;
    private Writer logWriter;
    private PrintStream vout = System.out;
    private String[] classpaths;

    public static void main(String[] stringArray) {
        StaticWeave staticWeave = new StaticWeave(stringArray);
        try {
            staticWeave.processCommandLine();
            staticWeave.start();
        }
        catch (Exception exception) {
            throw StaticWeaveException.exceptionPerformWeaving((Exception)exception, (Object)stringArray);
        }
    }

    public StaticWeave(String[] stringArray) {
        this.argv = stringArray;
    }

    public void start() throws Exception {
        StaticWeaveProcessor staticWeaveProcessor = new StaticWeaveProcessor(this.source, this.target);
        if (this.persistenceinfopath != null) {
            staticWeaveProcessor.setPersistenceInfo(this.persistenceinfopath);
        }
        if (this.classpaths != null) {
            staticWeaveProcessor.setClassLoader(this.getClassLoader());
        }
        if (this.logWriter != null) {
            staticWeaveProcessor.setLog(this.logWriter);
        }
        staticWeaveProcessor.setLogLevel(this.loglevel);
        staticWeaveProcessor.performWeaving();
    }

    void processCommandLine() throws Exception {
        if (this.argv.length < 2 || this.argv.length > 10) {
            this.printUsage();
            System.exit(1);
        }
        for (int i = 0; i < this.argv.length; ++i) {
            if (this.argv[i].equalsIgnoreCase("-classpath")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.classpaths = this.argv[i + 1].split(File.pathSeparator);
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-persistenceinfo")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.persistenceinfopath = this.argv[i + 1];
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-log")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.logWriter = new FileWriter(this.argv[i + 1]);
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-loglevel")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                if (this.argv[i + 1].equalsIgnoreCase("OFF") || this.argv[i + 1].equalsIgnoreCase("SEVERE") || this.argv[i + 1].equalsIgnoreCase("WARNING") || this.argv[i + 1].equalsIgnoreCase("INFO") || this.argv[i + 1].equalsIgnoreCase("CONFIG") || this.argv[i + 1].equalsIgnoreCase("FINE") || this.argv[i + 1].equalsIgnoreCase("FINER") || this.argv[i + 1].equalsIgnoreCase("FINEST") || this.argv[i + 1].equalsIgnoreCase("ALL")) {
                    this.loglevel = AbstractSessionLog.translateStringToLoggingLevel((String)this.argv[i + 1].toUpperCase());
                } else {
                    this.printUsage();
                    System.exit(1);
                }
                ++i;
                continue;
            }
            if (this.source != null) {
                this.printUsage();
                System.exit(1);
            }
            if (this.target != null) {
                this.printUsage();
                System.exit(1);
            }
            this.source = this.argv[i];
            if (i + 1 >= this.argv.length) {
                this.printUsage();
                System.exit(1);
            }
            if (++i >= this.argv.length) {
                this.printUsage();
                System.exit(1);
            }
            this.target = this.argv[i];
            ++i;
        }
        if (this.source == null) {
            this.printUsage();
            throw StaticWeaveException.missingSource();
        }
        if (this.target == null) {
            this.printUsage();
            throw StaticWeaveException.missingTarget();
        }
    }

    private void printUsage() {
        PrintStream printStream = this.vout;
        String string = ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_1of16");
        string = string + Helper.cr() + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_2of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_3of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_4of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_5of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_6of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_7of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_8of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_9of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_10of16");
        string = string + Helper.cr() + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_11of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_12of16");
        string = string + Helper.cr() + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_13of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_14of16");
        string = string + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_15of16");
        string = string + Helper.cr() + Helper.cr();
        string = string + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_16of16");
        string = string + Helper.cr() + Helper.cr();
        printStream.println(string);
    }

    private ClassLoader getClassLoader() throws MalformedURLException {
        if (this.classpaths != null) {
            URL[] uRLArray = new URL[this.classpaths.length];
            for (int i = 0; i < this.classpaths.length; ++i) {
                uRLArray[i] = new File(this.classpaths[i]).toURL();
            }
            return new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        }
        return null;
    }
}

