/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.LayoutViewHandler;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.FileUtil;
import com.sun.webui.theme.ThemeContext;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.glassfish.admingui.common.plugin.ConsoleClassLoader;
import org.glassfish.admingui.plugin.ConsolePluginService;
import org.glassfish.admingui.plugin.IntegrationPoint;
import org.glassfish.admingui.plugin.IntegrationPointComparator;
import org.glassfish.admingui.theme.AdminguiThemeContext;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHandlers {
    protected PluginHandlers() {
    }

    private static ConsolePluginService getPluginService(FacesContext ctx) {
        ServletContext servletCtx = (ServletContext)ctx.getExternalContext().getContext();
        Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
        return (ConsolePluginService)habitat.getByType(ConsolePluginService.class);
    }

    public static void getIntegrationPoints(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        List<IntegrationPoint> value = PluginHandlers.getIntegrationPoints(handlerCtx.getFacesContext(), type);
        handlerCtx.setOutputValue("points", value);
    }

    public static List<IntegrationPoint> getIntegrationPoints(FacesContext context, String type) {
        return PluginHandlers.getPluginService(context).getIntegrationPoints(type);
    }

    public static void includeIntegrations(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        UIComponent root = (UIComponent)handlerCtx.getInputValue("root");
        FacesContext ctx = handlerCtx.getFacesContext();
        List<IntegrationPoint> points = PluginHandlers.getIntegrationPoints(ctx, type);
        PluginHandlers.includeIntegrationPoints(ctx, root, PluginHandlers.getSortedIntegrationPoints(points));
    }

    public static void includeFirstIP(HandlerContext handlerCtx) throws IOException {
        Iterator<IntegrationPoint> it;
        String type = (String)handlerCtx.getInputValue("type");
        UIComponent root = (UIComponent)handlerCtx.getInputValue("root");
        FacesContext ctx = handlerCtx.getFacesContext();
        Set<IntegrationPoint> points = PluginHandlers.getSortedIntegrationPoints(PluginHandlers.getIntegrationPoints(ctx, type));
        if (points != null && (it = points.iterator()).hasNext()) {
            IntegrationPoint point = it.next();
            root = PluginHandlers.getIntegrationPointParent(root, point);
            if (point.getContent().lastIndexOf("://", 15) != -1) {
                URL contentURL = FileUtil.searchForFile((String)point.getContent(), null);
                if (contentURL == null) {
                    throw new IOException("Unable to locate file: " + point.getContent());
                }
                String content = new String(FileUtil.readFromURL((URL)contentURL));
                LayoutComponent stDesc = new LayoutComponent(null, "externalContent", new ComponentType("tmpTextCT", "com.sun.jsftemplating.component.factory.basic.StaticTextFactory"));
                stDesc.addOption("value", (Object)content);
                ComponentUtil.getInstance((FacesContext)ctx).createChildComponent(ctx, stDesc, root);
            } else {
                PluginHandlers.includeIntegrationPoint(ctx, root, point);
            }
        }
    }

    public static Set<IntegrationPoint> getSortedIntegrationPoints(List<IntegrationPoint> points) {
        if (points == null) {
            return null;
        }
        TreeSet<IntegrationPoint> sortedSet = new TreeSet<IntegrationPoint>((Comparator<IntegrationPoint>)IntegrationPointComparator.getInstance());
        sortedSet.addAll(points);
        return sortedSet;
    }

    public static void includeIntegrationPoints(FacesContext ctx, UIComponent root, Set<IntegrationPoint> points) {
        if (points == null) {
            return;
        }
        if (root == null) {
            root = ctx.getViewRoot();
        }
        Iterator<IntegrationPoint> it = null;
        int lastSize = 0;
        int currSize = points.size();
        String parentId = null;
        String lastParentId = null;
        while (currSize != lastSize) {
            lastSize = currSize;
            it = points.iterator();
            lastParentId = "";
            UIComponent parent = root;
            while (it.hasNext()) {
                IntegrationPoint point = it.next();
                parentId = point.getParentId();
                if (parentId == null || !parentId.equals(lastParentId)) {
                    parent = PluginHandlers.getIntegrationPointParent(root, point);
                }
                if (parent == null) {
                    lastParentId = null;
                    continue;
                }
                lastParentId = parent.getId();
                PluginHandlers.includeIntegrationPoint(ctx, parent, point);
                it.remove();
            }
            currSize = points.size();
        }
    }

    public static UIComponent getIntegrationPointParent(UIComponent root, IntegrationPoint point) {
        UIComponent parent = null;
        String parentId = point.getParentId();
        if (parentId == null) {
            parentId = root.getId();
            parent = root;
        } else {
            parent = PluginHandlers.findComponentById(root, parentId);
        }
        return parent;
    }

    public static void includeIntegrationPoint(FacesContext ctx, UIComponent parent, IntegrationPoint point) {
        String content = point.getContent();
        while (content.startsWith("/")) {
            content = content.substring(1);
        }
        String key = content;
        if (!key.contains("://")) {
            key = "/" + point.getConsoleConfigId() + "/" + content;
        }
        LayoutDefinition def = LayoutDefinitionManager.getLayoutDefinition((FacesContext)ctx, (String)key);
        LayoutViewHandler.buildUIComponentTree((FacesContext)ctx, (UIComponent)parent, (LayoutElement)def);
    }

    private static UIComponent findComponentById(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        Iterator it = base.getFacetsAndChildren();
        UIComponent comp = null;
        while (it.hasNext()) {
            comp = PluginHandlers.findComponentById((UIComponent)it.next(), id);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    public static void getTheme(HandlerContext handlerCtx) {
        String themeName = (String)handlerCtx.getInputValue("themeName");
        String themeVersion = (String)handlerCtx.getInputValue("themeVersion");
        ThemeContext themeContext = AdminguiThemeContext.getInstance(handlerCtx.getFacesContext(), themeName, themeVersion);
        handlerCtx.setOutputValue("themeContext", (Object)themeContext);
    }

    public static void getThemeFromIntegrationPoints(HandlerContext handlerCtx) {
        String type;
        FacesContext ctx = handlerCtx.getFacesContext();
        List<IntegrationPoint> ipList = PluginHandlers.getIntegrationPoints(ctx, type = "org.glassfish.admingui:customtheme");
        if (ipList != null) {
            int lowest = PluginHandlers.getLowestPriorityNum(ipList);
            for (IntegrationPoint ip : ipList) {
                int priority = ip.getPriority();
                if (priority != lowest) continue;
                String content = ip.getContent();
                if (content == null || content.equals("")) {
                    throw new IllegalArgumentException("No Properties File Name Provided!");
                }
                ClassLoader pluginCL = ConsoleClassLoader.findModuleClassLoader((String)ip.getConsoleConfigId());
                URL propertyFileURL = pluginCL.getResource("/" + content);
                try {
                    Properties propertyMap = new Properties();
                    propertyMap.load(propertyFileURL.openStream());
                    ThemeContext themeContext = AdminguiThemeContext.getInstance(ctx, propertyMap);
                    themeContext.setDefaultClassLoader(pluginCL);
                    handlerCtx.setOutputValue("themeContext", (Object)themeContext);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to access properties file '" + content + "'!", ex);
                }
            }
        }
    }

    private static int getLowestPriorityNum(List ipList) {
        Iterator iter = ipList.iterator();
        int lowest = 101;
        while (iter.hasNext()) {
            IntegrationPoint iP = (IntegrationPoint)iter.next();
            if (iP.getPriority() >= lowest) continue;
            lowest = iP.getPriority();
        }
        return lowest;
    }
}

