/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.config.ApplicationConfig;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.EngineConfig;
import com.sun.appserv.management.config.ModuleConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.enterprise.deploy.spi.Target;
import javax.management.ObjectName;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.AppUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.deployment.client.DeploymentFacility;

public class WebAppHandlers {
    private static Map<String, String> displayMap = new HashMap<String, String>();

    public static void getApplicationInfo(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        AMXRoot amxRoot = AMXRoot.getInstance();
        ApplicationConfig appConfig = (ApplicationConfig)amxRoot.getApplicationsConfig().getApplicationConfigMap().get(name);
        if (appConfig == null) {
            System.out.println("!!!!!! Error: Cannot find application with the name: " + name);
            return;
        }
        handlerCtx.setOutputValue("contextRoot", (Object)appConfig.getContextRoot());
        if (!amxRoot.supportCluster()) {
            handlerCtx.setOutputValue("vs", (Object)TargetUtil.getAssociatedVS((String)name, (String)"server"));
        }
        handlerCtx.setOutputValue("directoryDeployed", (Object)appConfig.getDirectoryDeployed());
        handlerCtx.setOutputValue("location", (Object)appConfig.getLocation());
        handlerCtx.setOutputValue("description", (Object)appConfig.getDescription());
        handlerCtx.setOutputValue("libraries", (Object)appConfig.getLibraries());
        if (amxRoot.isEE()) {
            handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)appConfig, (boolean)true));
        } else {
            handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isApplicationEnabled((Enabled)appConfig, (String)"server"));
        }
    }

    public static void saveApplicationInfo(HandlerContext handlerCtx) {
        String target = "server";
        String name = (String)handlerCtx.getInputValue("name");
        AMXRoot amxRoot = AMXRoot.getInstance();
        try {
            ApplicationConfig appConfig = (ApplicationConfig)amxRoot.getApplicationsConfig().getApplicationConfigMap().get(name);
            if (appConfig == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchApplication"));
                return;
            }
            appConfig.setContextRoot((String)handlerCtx.getInputValue("contextRoot"));
            if (amxRoot.isEE()) {
                appConfig.setAvailabilityEnabled((String)handlerCtx.getInputValue("availEnabled"));
            } else {
                String vs = (String)handlerCtx.getInputValue("vs");
                TargetUtil.setVirtualServers((String)name, (String)"server", (String)vs);
            }
            appConfig.setDescription((String)handlerCtx.getInputValue("description"));
            if (!amxRoot.isEE()) {
                Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                TargetUtil.setApplicationEnabled((Enabled)appConfig, (String)"server", (boolean)enabled);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getSubComponents(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        String appName = (String)handlerCtx.getInputValue("appName");
        ApplicationConfig appConfig = AMXUtil.getApplicationConfigByName((String)appName);
        Map mConfigs = appConfig.getModuleConfigMap();
        for (ModuleConfig mf : mConfigs.values()) {
            HashMap<String, String> oneRow = new HashMap<String, String>();
            oneRow.put("componentName", mf.getName());
            Map eConfigs = mf.getEngineConfigMap();
            ArrayList<String> snifferList = new ArrayList<String>();
            for (EngineConfig ec : eConfigs.values()) {
                String sniffer = ec.getSniffer();
                if (AppUtil.sniffersHide.contains(sniffer)) continue;
                snifferList.add(sniffer);
            }
            Collections.sort(snifferList);
            oneRow.put("engines", ((Object)snifferList).toString());
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getDeployedAppsInfo(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty((String)filterValue)) {
            filterValue = null;
        }
        ArrayList result = new ArrayList();
        Map appsConfig = AMXRoot.getInstance().getApplicationsConfig().getApplicationConfigMap();
        for (ApplicationConfig appConfig : appsConfig.values()) {
            if (!"user".equals(appConfig.getObjectType())) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            String enable = TargetUtil.getEnabledStatus((Enabled)appConfig, (boolean)true);
            String enableURL = enable.equals("true") ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            oneRow.put("name", appConfig.getName());
            oneRow.put("enableURL", enableURL);
            oneRow.put("selected", false);
            List sniffersList = AppUtil.getAllSniffers((ApplicationConfig)appConfig);
            oneRow.put("sniffersList", sniffersList);
            oneRow.put("sniffers", sniffersList.toString());
            for (int ix = 0; ix < sniffersList.size(); ++ix) {
                filters.add((String)sniffersList.get(ix));
            }
            if (filterValue != null && !sniffersList.contains(filterValue)) continue;
            WebAppHandlers.getLaunchInfo(serverName, appConfig, oneRow);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    private static void getLaunchInfo(String serverName, ApplicationConfig appConfig, Map oneRow) {
        boolean enabled = TargetUtil.isApplicationEnabled((Enabled)appConfig, (String)"server");
        String contextRoot = appConfig.getContextRoot();
        String composite = AMXUtil.getPropertyValue((PropertiesAccess)appConfig, (String)"isComposite");
        oneRow.put("contextRoot", GuiUtil.isEmpty((String)contextRoot) ? "" : contextRoot);
        if (GuiUtil.isEmpty((String)contextRoot)) {
            contextRoot = "";
        }
        oneRow.put("composite", "true".equals(composite) ? "true" : "false");
        oneRow.put("hasLaunch", false);
        if (!enabled || composite.equals("true") || contextRoot.equals("")) {
            return;
        }
        String enableStr = TargetUtil.getEnabledStatus((Enabled)appConfig, (boolean)true);
        String protocol = "http";
        String port = V3AMX.getPortForApplication((String)appConfig.getName());
        if (port == null) {
            oneRow.put("port", "");
            oneRow.put("hasLaunch", false);
        } else {
            if (port.startsWith("-")) {
                protocol = "https";
                port = port.substring(1);
            }
            oneRow.put("port", port);
            if (AMXRoot.getInstance().isEE()) {
                if (enableStr.equals(GuiUtil.getMessage((String)"deploy.allDisabled")) || enableStr.equals(GuiUtil.getMessage((String)"deploy.noTarget"))) {
                    oneRow.put("hasLaunch", false);
                } else {
                    oneRow.put("hasLaunch", true);
                }
            } else {
                oneRow.put("hasLaunch", Boolean.parseBoolean(enableStr));
                String ctxRoot = WebAppHandlers.calContextRoot(contextRoot);
                oneRow.put("launchLink", protocol + "://" + serverName + ":" + port + ctxRoot);
            }
        }
    }

    public static void restartApplication(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String[] targetNames = new String[]{"server"};
        try {
            DeploymentFacility df = GuiUtil.getDeploymentFacility();
            Target[] targets = df.createTargets(targetNames);
            df.disable(targets, appName);
            df.enable(targets, appName);
            if (AMXRoot.getInstance().isEE()) {
                GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"success", (String)GuiUtil.getMessage((String)"org.glassfish.web.admingui.Strings", (String)"restart.success"), null);
            } else {
                GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"success", (String)GuiUtil.getMessage((String)"org.glassfish.web.admingui.Strings", (String)"restart.successPE"), null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    protected String getHost(ObjectName serverInstance) {
        return "";
    }

    public static String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }
}

