/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.faces.integration;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.net.JarURIPattern;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.glassfish.api.web.TldProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jsfTld")
@Scoped(value=Singleton.class)
public class GlassFishTldProvider
implements TldProvider,
PostConstruct {
    @Inject
    ModulesRegistry registry;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();

    public Map<URI, List<String>> getTldMap() {
        return (Map)((HashMap)this.tldMap).clone();
    }

    public void postConstruct() {
        Class<?> jsfImplClass = null;
        try {
            jsfImplClass = this.getClass().getClassLoader().loadClass("com.sun.faces.spi.InjectionProvider");
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        URI[] uris = null;
        Module m = null;
        if (jsfImplClass != null) {
            m = this.registry.find(jsfImplClass);
        }
        if (m != null) {
            uris = m.getModuleDefinition().getLocations();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                if (urls != null && urls.length > 0) {
                    uris = new URI[urls.length];
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            uris[i] = urls[i].toURI();
                            continue;
                        }
                        catch (URISyntaxException e) {
                            System.out.println("Ignoring " + uris[i] + " because of " + e);
                        }
                    }
                }
            } else {
                System.out.println("ClassLoader [" + classLoader + "] is not of type URLClassLoader");
            }
        }
        if (uris != null && uris.length > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : uris) {
                List entries = JarURIPattern.getJarEntries((URI)uri, (Pattern)pattern);
                if (entries == null || entries.size() <= 0) continue;
                this.tldMap.put(uri, entries);
            }
        }
    }
}

