/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.JavaConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Map;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;

public class SecurityHandlers {
    private static final String JVM_OPTION_SECURITY_MANAGER = "-Djava.security.manager";
    private static final String JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL = "-Djava.security.manager=";

    public static void getSecuritySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        String principal = sConfig.getDefaultPrincipal();
        String password = sConfig.getDefaultPrincipalPassword();
        String mapped = sConfig.getMappedPrincipalClass();
        String realm = sConfig.getDefaultRealm();
        String module = sConfig.getAuditModules();
        String jacc = sConfig.getJACC();
        handlerCtx.setOutputValue("Audit", (Object)sConfig.getAuditEnabled());
        handlerCtx.setOutputValue("Principal", (Object)principal);
        handlerCtx.setOutputValue("Password", (Object)password);
        handlerCtx.setOutputValue("RoleMapping", (Object)sConfig.getActivateDefaultPrincipalToRoleMapping());
        handlerCtx.setOutputValue("Mapped", (Object)mapped);
        handlerCtx.setOutputValue("Realm", (Object)realm);
        handlerCtx.setOutputValue("Module", (Object)module);
        handlerCtx.setOutputValue("Jacc", (Object)jacc);
        handlerCtx.setOutputValue("Properties", (Object)sConfig.getPropertyConfigMap());
    }

    public static void saveSecuritySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        AMXUtil.updateProperties((PropertiesAccess)sConfig, (Map)((Map)handlerCtx.getInputValue("newProps")));
        sConfig.setAuditEnabled((String)handlerCtx.getInputValue("Audit"));
        sConfig.setDefaultPrincipal((String)handlerCtx.getInputValue("Principal"));
        sConfig.setDefaultPrincipalPassword((String)handlerCtx.getInputValue("Password"));
        sConfig.setActivateDefaultPrincipalToRoleMapping((String)handlerCtx.getInputValue("RoleMapping"));
        sConfig.setMappedPrincipalClass((String)handlerCtx.getInputValue("Mapped"));
        sConfig.setJACC((String)handlerCtx.getInputValue("Jaccs"));
        sConfig.setAuditModules((String)handlerCtx.getInputValue("Modules"));
        sConfig.setDefaultRealm((String)handlerCtx.getInputValue("Realms"));
    }

    public static void getSecurityManagerStatus(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        handlerCtx.setOutputValue("securityManagerEnabled", (Object)SecurityHandlers.isSecurityManagerEnabled(config));
    }

    public static void saveSecurityManagerStatus(HandlerContext handlerCtx) {
        int i;
        Boolean userValue;
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        String value = (String)handlerCtx.getInputValue("SecurityManagerStatus");
        Boolean status = SecurityHandlers.isSecurityManagerEnabled(config);
        if (status.equals(userValue = new Boolean(value))) {
            return;
        }
        ArrayList<String> newOptions = new ArrayList<String>();
        JavaConfig javaConfig = config.getJavaConfig();
        String[] origOptions = javaConfig.getJVMOptions();
        if (userValue.booleanValue()) {
            for (i = 0; i < origOptions.length; ++i) {
                newOptions.add(origOptions[i]);
            }
            newOptions.add(JVM_OPTION_SECURITY_MANAGER);
        } else {
            for (i = 0; i < origOptions.length; ++i) {
                if (origOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) || origOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                newOptions.add(origOptions[i]);
            }
        }
        String[] jvmOptions = newOptions.toArray(new String[0]);
        javaConfig.setJVMOptions(jvmOptions);
    }

    public static void getSecurityDefaultAttributes(HandlerContext handlerCtx) {
        Map defaultMap = AMXRoot.getInstance().getResourcesConfig().getDefaultValues("X-SecurityServiceConfig");
        handlerCtx.setOutputValue("Audit", defaultMap.get("AuditEnabled"));
        handlerCtx.setOutputValue("Principal", defaultMap.get("DefaultPrincipal"));
        handlerCtx.setOutputValue("Password", defaultMap.get("DefaultPrincipalPassword"));
        handlerCtx.setOutputValue("RoleMapping", defaultMap.get("ActivateDefaultPrincipalToRoleMapping"));
        handlerCtx.setOutputValue("Mapped", defaultMap.get("MappedPrincipalClass"));
        handlerCtx.setOutputValue("Jaccs", defaultMap.get("JACC"));
        handlerCtx.setOutputValue("Modules", defaultMap.get("AuditModules"));
        handlerCtx.setOutputValue("Realms", defaultMap.get("DefaultRealm"));
    }

    public static void getRealms(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map realmsMap = sConfig.getAuthRealmConfigMap();
        ArrayList realms = new ArrayList(realmsMap.keySet());
        handlerCtx.setOutputValue("Realms", realms);
    }

    public static void getAuditModules(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map modules = sConfig.getAuditModuleConfigMap();
        ArrayList modulesMap = new ArrayList(modules.keySet());
        handlerCtx.setOutputValue("AuditModules", modulesMap);
    }

    private static Boolean isSecurityManagerEnabled(ConfigConfig config) {
        String[] jvmOptions = config.getJavaConfig().getJVMOptions();
        if (jvmOptions != null && jvmOptions.length > 0) {
            for (int i = 0; i < jvmOptions.length; ++i) {
                if (!jvmOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) && !jvmOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

