/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.ext.logging.LogModuleNames;
import com.sun.appserv.management.ext.logging.LogQueryEntry;
import com.sun.appserv.management.ext.logging.LogQueryResult;
import com.sun.appserv.management.ext.logging.Logging;
import com.sun.appserv.management.helper.Helper;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatefulLoggingHelper
extends Helper {
    private Logging mLogging;
    private String mLogFile;
    private long mStartIndex;
    private Set<String> mModules;
    private boolean mSearchForward;
    private int mMaxRecords;
    private Long mStartTime;
    private Long mStopTime;
    private String mLogLevel;
    private List<Attribute> mAttrs;

    public StatefulLoggingHelper(Logging logging) {
        super(logging.getDomainRoot());
        this.mLogging = logging;
        this.mLogFile = "MostRecentLogFileName";
        this.mStartIndex = 0L;
        this.mSearchForward = true;
        this.mLogLevel = Logging.LOWEST_SUPPORTED_QUERY_LEVEL;
        this.mModules = LogModuleNames.ALL_NAMES;
        this.mMaxRecords = -1;
        this.mStartTime = null;
        this.mStopTime = null;
        this.mAttrs = new ArrayList<Attribute>();
    }

    public Logging getLogging() {
        return this.mLogging;
    }

    public String getLogFile() {
        return this.mLogFile;
    }

    public long getStartIndex() {
        return this.mStartIndex;
    }

    public Set<String> getModules() {
        return this.mModules;
    }

    public List<Attribute> getAttrs() {
        return this.mAttrs;
    }

    public boolean getSearchForward() {
        return this.mSearchForward;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getStopTime() {
        return this.mStopTime;
    }

    public String getLogLevel() {
        return this.mLogLevel;
    }

    public int getMaxRecords() {
        return this.mMaxRecords;
    }

    public void setLogFile(String name) {
        if (!this.mLogFile.equals(name)) {
            this.mLogFile = name;
            this.setStartIndex(this.getSearchForward() ? 0 : -1);
        }
    }

    public void setStartIndex(int startIndex) {
        this.mStartIndex = startIndex;
    }

    public void setLogLevel(String logLevel) {
        this.mLogLevel = logLevel;
    }

    public void setMaxRecords(int maxRecords) {
        this.mMaxRecords = maxRecords;
    }

    public void setModules(Set<String> modules) {
        this.mModules = modules;
    }

    public void setModule(String module) {
        this.mModules = GSetUtil.newSet(module);
    }

    public void setAttrs(List<Attribute> attrs) {
        this.mAttrs.clear();
        this.mAttrs.addAll(attrs);
    }

    public void setSearchForward(boolean searchForward) {
        this.mSearchForward = true;
    }

    public void setStartTime(Long startTime) {
        this.mStartTime = startTime;
    }

    public void setStopTime(Long stopTime) {
        this.mStopTime = stopTime;
    }

    public LogQueryResult query() {
        Logging logging = this.getLogging();
        assert (logging != null);
        LogQueryResult result = logging.queryServerLog(this.mLogFile, this.mStartIndex, this.mSearchForward, this.mMaxRecords, this.mStartTime, this.mStopTime, this.mLogLevel, this.mModules, this.mAttrs);
        LogQueryEntry[] entries = result.getEntries();
        if (entries.length != 0) {
            this.mStartIndex = this.mSearchForward ? entries[entries.length - 1].getRecordNumber() + 1L : entries[0].getRecordNumber();
        }
        return result;
    }
}

