/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.BindingsIterator;
import com.sun.enterprise.naming.impl.JavaURLContext;
import com.sun.enterprise.naming.impl.NamePairsEnum;
import com.sun.enterprise.naming.impl.ProviderManager;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public final class GlassfishNamingManagerImpl
implements GlassfishNamingManager {
    static Logger _logger = LogFacade.getLogger();
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.util.IIOPObjectFactory";
    @Inject
    InvocationManager invMgr;
    private InitialContext initialContext;
    private Context cosContext;
    private NameParser nameParser = new SerialNameParser();
    private Hashtable namespaces;

    public GlassfishNamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    void setInvocationManager(InvocationManager invMgr) {
        this.invMgr = invMgr;
    }

    public GlassfishNamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.namespaces = new Hashtable();
        JavaURLContext.setNamingManager(this);
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    public Remote initializeRemoteNamingSupport(ORB orb) throws NamingException {
        Remote remoteProvider = null;
        try {
            Hashtable<String, String> cosNamingEnv = new Hashtable<String, String>();
            cosNamingEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            cosNamingEnv.put("java.naming.corba.orb", (String)orb);
            this.cosContext = new InitialContext(cosNamingEnv);
            ProviderManager pm = ProviderManager.getProviderManager();
            remoteProvider = pm.initRemoteProvider(orb);
        }
        catch (RemoteException re) {
            NamingException ne = new NamingException("Exception during remote naming initialization");
            ne.initCause(ne);
            throw ne;
        }
        return remoteProvider;
    }

    private Context getCosContext() {
        return this.cosContext;
    }

    public void publishObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        java.lang.Object serialObj = obj;
        if (rebind) {
            this.initialContext.rebind(name, serialObj);
        } else {
            this.initialContext.bind(name, serialObj);
        }
    }

    public void publishCosNamingObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameObj = new CompositeName(name);
        this.createSubContexts(nameObj, this.getCosContext());
        if (rebind) {
            this.getCosContext().rebind(name, obj);
        } else {
            this.getCosContext().bind(name, obj);
        }
        Reference serialObj = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        this.publishObject(name, (java.lang.Object)serialObj, rebind);
    }

    public void unpublishObject(String name) throws NamingException {
        this.initialContext.unbind(name);
    }

    public void unpublishCosNamingObject(String name) throws NamingException {
        try {
            this.getCosContext().unbind(name);
        }
        catch (NamingException cne) {
            _logger.log(Level.WARNING, "Error during CosNaming.unbind for " + name);
        }
        this.initialContext.unbind(name);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating sub contexts for " + name);
        }
        for (int subCtxIndex = 0; subCtxIndex < numSubContexts; ++subCtxIndex) {
            Context newCtx;
            String subCtxName = name.get(subCtxIndex);
            try {
                java.lang.Object obj = currentCtx.lookup(subCtxName);
                if (obj == null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "name == null");
                    }
                    currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                    continue;
                }
                if (obj instanceof Context) {
                    currentCtx = (Context)obj;
                    continue;
                }
                throw new NameAlreadyBoundException(subCtxName);
            }
            catch (NameNotFoundException e) {
                _logger.log(Level.FINE, "name not found", e);
                currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
            }
        }
    }

    private HashMap getComponentNameSpace(String componentId) throws NamingException {
        HashMap<String, JavaURLContext> namespace = (HashMap<String, JavaURLContext>)this.namespaces.get(componentId);
        if (namespace == null) {
            namespace = new HashMap<String, JavaURLContext>();
            this.namespaces.put(componentId, namespace);
            JavaURLContext jc = new JavaURLContext("java:", null);
            namespace.put("java:", jc);
            namespace.put("java:/", jc);
            JavaURLContext jcc = new JavaURLContext("java:comp", null);
            namespace.put("java:comp", jcc);
            namespace.put("java:comp/", jcc);
            JavaURLContext jccEnv = new JavaURLContext("java:comp/env", null);
            namespace.put("java:comp/env", jccEnv);
            namespace.put("java:comp/env/", jccEnv);
        }
        return namespace;
    }

    public void bindToComponentNamespace(String appName, String componentId, String logicalJndiName, java.lang.Object value) throws NamingException {
        HashMap namespace = this.getComponentNameSpace(componentId);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "naming.bind Binding name:{0}", new java.lang.Object[]{logicalJndiName});
        }
        if (namespace.put(logicalJndiName, value) != null) {
            _logger.log(Level.WARNING, "naming.alreadyexistsReference name [{0}] already exists in {1}", new java.lang.Object[]{logicalJndiName, appName});
        }
        this.bindIntermediateContexts(namespace, logicalJndiName);
    }

    public void bindToComponentNamespace(String appName, String componentId, Collection<? extends JNDIBinding> bindings) throws NamingException {
        for (JNDIBinding jNDIBinding : bindings) {
            this.bindToComponentNamespace(appName, componentId, jNDIBinding.getName(), jNDIBinding.getValue());
        }
    }

    private void bindIntermediateContexts(HashMap namespace, String name) throws NamingException {
        name = name.substring("java:comp/".length());
        StringTokenizer toks = new StringTokenizer(name, "/", false);
        String partialName = "java:comp";
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            if (namespace.get(partialName = partialName + "/" + tok) != null) continue;
            namespace.put(partialName, new JavaURLContext(partialName, null));
        }
    }

    public void unbindObjects(String componentId) throws NamingException {
        this.namespaces.remove(componentId);
    }

    public Context restoreJavaCompEnvContext(String contextName) throws NamingException {
        if (!contextName.startsWith("java:")) {
            throw new NamingException("Invalid context name [" + contextName + "]. Name must start with java:");
        }
        return new JavaURLContext(contextName, null);
    }

    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(name, null);
    }

    public java.lang.Object lookup(String name, SerialContext serialContext) throws NamingException {
        String componentId;
        HashMap namespace;
        java.lang.Object obj;
        _logger.fine("serialcontext in GlassfishNamingManager.." + serialContext);
        Context ic = null;
        ic = serialContext != null ? serialContext : this.initialContext;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "GlassfishNamingManager : looking up name : " + name);
        }
        if ((obj = (namespace = this.getComponentNameSpace(componentId = this.getComponentId())).get(name)) == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (obj instanceof NamingObjectProxy) {
            NamingObjectProxy namingProxy = (NamingObjectProxy)obj;
            obj = namingProxy.create(ic);
        }
        return obj;
    }

    public NamingEnumeration list(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new NamePairsEnum(this, list.iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new BindingsIterator(this, list.iterator());
    }

    private ArrayList listNames(String name) throws NamingException {
        String componentId = this.getComponentId();
        HashMap namespace = (HashMap)this.namespaces.get(componentId);
        java.lang.Object obj = namespace.get(name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (!(obj instanceof JavaURLContext)) {
            throw new NotContextException(name + " cannot be listed");
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = namespace.keySet().iterator();
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(name) || key.indexOf(47, name.length()) != -1) continue;
            list.add(key);
        }
        return list;
    }

    private String getComponentId() throws NamingException {
        String id = null;
        ComponentInvocation ci = this.invMgr.getCurrentInvocation();
        if (ci == null) {
            throw new NamingException("Invocation exception: Got null ComponentInvocation ");
        }
        try {
            id = ci.getComponentId();
            if (id == null) {
                NamingException nameEx = new NamingException("Invocation exception: ComponentId is null");
                throw nameEx;
            }
        }
        catch (Throwable th) {
            NamingException ine = new NamingException("Invocation exception: " + th);
            ine.initCause(th);
            throw ine;
        }
        return id;
    }

    private boolean isCOSNamingObj(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object;
    }
}

