/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.hibernate.validation.jtype.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static <T> T getAnnotationParameter(Annotation annotation, String parameterName, Class<T> type) {
        try {
            Method m = annotation.getClass().getMethod(parameterName, new Class[0]);
            Object o = m.invoke((Object)annotation, new Object[0]);
            if (o.getClass().getName().equals(type.getName())) {
                return (T)o;
            }
            String msg = "Wrong parameter type. Expected: " + type.getName() + " Actual: " + o.getClass().getName();
            throw new ValidationException(msg);
        }
        catch (NoSuchMethodException e) {
            String msg = "The specified annotation defines no parameter '" + parameterName + "'.";
            throw new ValidationException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to get '" + parameterName + "' from " + annotation.getClass().getName();
            throw new ValidationException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Unable to get '" + parameterName + "' from " + annotation.getClass().getName();
            throw new ValidationException(msg, e);
        }
    }

    public static String getPropertyName(Member member) {
        String name = null;
        if (member instanceof Field) {
            name = member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            if (methodName.startsWith("is")) {
                name = Introspector.decapitalize(methodName.substring(2));
            } else if (methodName.startsWith("get")) {
                name = Introspector.decapitalize(methodName.substring(3));
            }
        }
        return name;
    }

    public static Class<?> getType(Member member) {
        Class<?> type = null;
        if (member instanceof Field) {
            type = ((Field)member).getType();
        }
        if (member instanceof Method) {
            type = ((Method)member).getReturnType();
        }
        return type;
    }

    public static Class<?> getAnnotations(Member member) {
        Class<?> type = null;
        if (member instanceof Field) {
            type = ((Field)member).getType();
        }
        if (member instanceof Method) {
            type = ((Method)member).getReturnType();
        }
        return type;
    }

    public static Type typeOf(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        throw new IllegalArgumentException("Member " + member + " is neither a field nor a method");
    }

    public static Object getValue(Member member, Object object) {
        Object value = null;
        if (member instanceof Method) {
            Method method = (Method)member;
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + method.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to access " + method.getName(), e);
            }
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + field.getName(), e);
            }
        }
        return value;
    }

    public static void setAccessibility(Member member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }

    public static Class<?> loadClass(String name, Class<?> caller) throws ClassNotFoundException {
        block3: {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    return loader.loadClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                if (caller != null) break block3;
                throw e;
            }
        }
        return Class.forName(name, true, caller.getClassLoader());
    }

    public static Type getIndexedType(Type type) {
        Type indexedType = null;
        if (ReflectionHelper.isIterable(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[0];
        } else if (ReflectionHelper.isMap(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[1];
        } else if (TypeUtils.isArray(type)) {
            indexedType = TypeUtils.getComponentType(type);
        }
        return indexedType;
    }

    public static boolean isIterable(Type type) {
        if (type instanceof Class && ReflectionHelper.isIterableClass((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isIterable(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isIterable(upperBounds[0]);
        }
        return false;
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && ReflectionHelper.isMapClass((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isMap(upperBounds[0]);
        }
        return false;
    }

    public static Object getIndexedValue(Object value, String index) {
        if (value == null) {
            return null;
        }
        int numIndex = -1;
        try {
            numIndex = Integer.valueOf(index);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (numIndex == -1) {
            Map map = (Map)value;
            return map.get(index);
        }
        Iterator<Object> iter = null;
        Class<?> type = value.getClass();
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
        } else if (ReflectionHelper.isMap(type)) {
            Map map = (Map)value;
            iter = map.values().iterator();
        } else if (TypeUtils.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
        }
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (i == numIndex) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static boolean containsMember(Class<?> clazz, String property) {
        return ReflectionHelper.containsField(clazz, property) || ReflectionHelper.containsMethod(clazz, property);
    }

    public static boolean containsField(Class<?> clazz, String fieldName) {
        try {
            clazz.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            ReflectionHelper.setAccessibility(field);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static boolean containsMethod(Class<?> clazz, String methodName) {
        try {
            clazz.getMethod("get" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1), new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        try {
            return clazz.getMethod("get" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Class<?> classForName(String name, Class<?> caller) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name, true, caller.getClassLoader());
    }

    private static void computeClassHierarchy(Class<?> clazz, List<Class<?>> classes) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                ReflectionHelper.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private static boolean isIterableClass(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        ReflectionHelper.computeClassHierarchy(clazz, classes);
        return classes.contains(Iterable.class);
    }

    private static boolean isMapClass(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        ReflectionHelper.computeClassHierarchy(clazz, classes);
        return classes.contains(Map.class);
    }
}

