/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
extends Resource
implements Externalizable {
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private transient ResourceInfo resourceInfo;
    private transient Map<String, String> responseHeaders;
    private long initialTime;
    private long maxAge;

    public ResourceImpl() {
    }

    public ResourceImpl(ResourceInfo resourceInfo, String contentType, long initialTime, long maxAge) {
        this.resourceInfo = resourceInfo;
        super.setResourceName(resourceInfo.getName());
        super.setLibraryName(resourceInfo.getLibraryInfo() != null ? resourceInfo.getLibraryInfo().getName() : null);
        super.setContentType(contentType);
        this.initialTime = initialTime;
        this.maxAge = maxAge;
    }

    public InputStream getInputStream() throws IOException {
        FacesContext ctx = FacesContext.getCurrentInstance();
        InputStream result = this.isEvaluateExpressions() ? this.getExpressionEvaluatingInputStream(ctx) : this.resourceInfo.getHelper().getInputStream(this.resourceInfo, ctx);
        return result;
    }

    private InputStream getExpressionEvaluatingInputStream(final FacesContext context) throws IOException {
        final InputStream inner = this.resourceInfo.getHelper().getInputStream(this.resourceInfo, context);
        InputStream result = new InputStream(){
            private List<Integer> buf = new ArrayList<Integer>(1024);
            boolean failedExpressionTest = false;
            boolean writingExpression = false;
            private int nextRead = -1;

            public boolean isWritingExpression() {
                return this.writingExpression;
            }

            public void setWritingExpression(boolean writingExpression) {
                this.writingExpression = writingExpression;
            }

            public boolean isFailedExpressionTest() {
                return this.failedExpressionTest;
            }

            public void setFailedExpressionTest(boolean testingForExpression) {
                this.failedExpressionTest = testingForExpression;
            }

            public List<Integer> getBuf() {
                return this.buf;
            }

            @Override
            public int read() throws IOException {
                int i;
                if (this.isFailedExpressionTest()) {
                    i = this.nextRead;
                    this.nextRead = -1;
                    this.setFailedExpressionTest(false);
                } else if (this.isWritingExpression()) {
                    if (0 < this.getBuf().size()) {
                        i = this.getBuf().remove(0);
                    } else {
                        this.setWritingExpression(false);
                        i = inner.read();
                    }
                } else {
                    i = inner.read();
                    char c = (char)i;
                    if (c == '#') {
                        i = inner.read();
                        c = (char)i;
                        if (c == '{') {
                            this.readExpressionIntoBufferAndEvaluateIntoBuffer();
                            this.setWritingExpression(true);
                            i = this.read();
                        } else {
                            i = 35;
                            this.nextRead = c;
                            this.setFailedExpressionTest(true);
                        }
                    }
                }
                return i;
            }

            private void readExpressionIntoBufferAndEvaluateIntoBuffer() throws IOException {
                int i;
                char c;
                do {
                    if ((c = (char)(i = inner.read())) == '}') {
                        this.evaluateExpressionIntoBuffer();
                        continue;
                    }
                    this.getBuf().add(i);
                } while (c != '}' && i != -1);
            }

            private void evaluateExpressionIntoBuffer() {
                List<Integer> buf = this.getBuf();
                char[] chars = new char[buf.size()];
                int len = buf.size();
                for (int i = 0; i < len; ++i) {
                    chars[i] = (char)buf.get(i).intValue();
                }
                String expressionBody = new String(chars);
                int colon = expressionBody.indexOf(":");
                if (-1 != colon) {
                    if (!this.isPropertyValid(expressionBody)) {
                        throw new ELException("Invalid resource format.  Property " + expressionBody + " contains more than one colon (:)");
                    }
                    String[] parts = Util.split(expressionBody, ":");
                    if (null == parts[0] || null == parts[1]) {
                        throw new ELException("Invalid resource format.  Property " + expressionBody + " cannot be parsed to extract resource name and library name");
                    }
                    try {
                        int mark = parts[0].indexOf("[") + 2;
                        char quoteMark = parts[0].charAt(mark - 1);
                        parts[0] = parts[0].substring(mark, colon);
                        if (parts[0].equals("this")) {
                            parts[0] = ResourceImpl.this.getLibraryName();
                            mark = parts[1].indexOf("]") - 1;
                            parts[1] = parts[1].substring(0, mark);
                            expressionBody = "resource[" + quoteMark + parts[0] + ":" + parts[1] + quoteMark + "]";
                        }
                    }
                    catch (Exception e) {
                        throw new ELException("Invalid resource format.  Property " + expressionBody + " cannot be parsed");
                    }
                }
                ELContext elContext = context.getELContext();
                ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + expressionBody + "}", String.class);
                Object value = ve.getValue(elContext);
                String expressionResult = value != null ? value.toString() : "";
                buf.clear();
                int len2 = expressionResult.length();
                for (int i = 0; i < len2; ++i) {
                    buf.add(Integer.valueOf(expressionResult.charAt(i)));
                }
            }

            private boolean isPropertyValid(String property) {
                int idx = property.indexOf(58);
                return property.indexOf(58, idx + 1) == -1;
            }
        };
        return result;
    }

    private boolean isEvaluateExpressions() {
        String contentType = this.getContentType();
        return "text/css".equals(contentType) || "text/javascript".equals(contentType) || "application/x-javascript".equals(contentType);
    }

    public URL getURL() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return this.resourceInfo.getHelper().getURL(this.resourceInfo, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResponseHeaders() {
        if (this.isResourceRequest()) {
            if (this.responseHeaders == null) {
                this.responseHeaders = new HashMap<String, String>(6, 1.0f);
            }
            long expiresTime = new Date().getTime() + this.maxAge;
            SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
            format.setTimeZone(GMT);
            this.responseHeaders.put("Expires", format.format(new Date(expiresTime)));
            URL url = this.getURL();
            InputStream in = null;
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                in = conn.getInputStream();
                long lastModified = conn.getLastModified();
                long contentLength = conn.getContentLength();
                if (lastModified == 0L) {
                    lastModified = this.initialTime;
                }
                this.responseHeaders.put("Last-Modified", format.format(new Date(lastModified)));
                if (lastModified != 0L && contentLength != -1L) {
                    this.responseHeaders.put("ETag", "W/\"" + contentLength + '-' + lastModified + '\"');
                }
            }
            catch (IOException ignored) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return this.responseHeaders;
        }
        return Collections.emptyMap();
    }

    public String getRequestPath() {
        String localePrefix;
        FacesContext context = FacesContext.getCurrentInstance();
        String facesServletMapping = Util.getFacesMapping(context);
        String uri = Util.isPrefixMapped(facesServletMapping) ? facesServletMapping + "/javax.faces.resource" + '/' + this.getResourceName() : "/javax.faces.resource/" + this.getResourceName() + facesServletMapping;
        boolean queryStarted = false;
        if (null != this.getLibraryName()) {
            queryStarted = true;
            uri = uri + "?ln=" + this.getLibraryName();
        }
        String version = "";
        if (this.resourceInfo.getLibraryInfo() != null && this.resourceInfo.getLibraryInfo().getVersion() != null) {
            version = version + this.resourceInfo.getLibraryInfo().getVersion().toString();
        }
        if (this.resourceInfo.getVersion() != null) {
            version = version + this.resourceInfo.getVersion().toString();
        }
        if (version.length() > 0) {
            uri = uri + (queryStarted ? "&v=" : "?v=") + version;
        }
        if ((localePrefix = this.resourceInfo.getLocalePrefix()) != null) {
            uri = uri + (queryStarted ? "&loc=" : "?loc=") + localePrefix;
        }
        uri = context.getApplication().getViewHandler().getResourceURL(context, uri);
        return uri;
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        Map requestHeaders = context.getExternalContext().getRequestHeaderMap();
        return !requestHeaders.containsKey("If-Modified-Since") || this.resourceInfo.getHelper().getLastModified(this.resourceInfo, context) > this.initialTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getResourceName());
        out.writeObject(this.getLibraryName());
        out.writeObject(this.getContentType());
        out.writeLong(this.initialTime);
        out.writeLong(this.maxAge);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setResourceName((String)in.readObject());
        this.setLibraryName((String)in.readObject());
        this.setContentType((String)in.readObject());
        this.initialTime = in.readLong();
        this.maxAge = in.readLong();
        ResourceManager manager = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext()).getResourceManager();
        this.resourceInfo = manager.findResource(this.getLibraryName(), this.getResourceName(), this.getContentType(), FacesContext.getCurrentInstance());
    }

    private boolean isResourceRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return ctx.getApplication().getResourceHandler().isResourceRequest(ctx);
    }
}

