/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.QueryMgr;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.AMXProxyHandler;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.RegexUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.ObjectNameQueryImpl;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMgrImpl
extends AMXImplBase {
    public QueryMgrImpl(ObjectName parentObjectName) {
        super(parentObjectName, QueryMgr.class);
    }

    private static Set<ObjectName> checked(Set<ObjectName> s) {
        return Collections.checkedSet(s, ObjectName.class);
    }

    public static Set<ObjectName> queryPropsObjectNameSet(MBeanServerConnection conn, String jmxDomainName, String props) throws IOException {
        ObjectName pattern = Util.newObjectNamePattern((String)jmxDomainName, (String)props);
        Set names = JMXUtil.queryNames((MBeanServerConnection)conn, (ObjectName)pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public static Set<ObjectName> queryPropsObjectNameSet(MBeanServer server, String jmxDomainName, String props) {
        ObjectName pattern = Util.newObjectNamePattern((String)jmxDomainName, (String)props);
        Set names = JMXUtil.queryNames((MBeanServer)server, (ObjectName)pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public Set<ObjectName> queryPropsObjectNameSet(String props) {
        String myDomain = this.getObjectName().getDomain();
        Set<ObjectName> names = QueryMgrImpl.queryPropsObjectNameSet(this.getMBeanServer(), myDomain, props);
        return QueryMgrImpl.checked(names);
    }

    public ObjectName querySingletonJ2EETypeObjectName(String type) {
        return QueryMgrImpl.querySingletonJ2EETypeObjectName(this.getMBeanServer(), this.getObjectName().getDomain(), type);
    }

    public static ObjectName querySingletonJ2EETypeObjectName(MBeanServer server, String domainName, String typeValue) {
        try {
            ObjectName objectName = QueryMgrImpl.querySingletonJ2EETypeObjectName((MBeanServerConnection)server, domainName, typeValue);
            return objectName;
        }
        catch (IOException e) {
            assert (false);
            throw new RuntimeException(e);
        }
    }

    public static ObjectName querySingletonJ2EETypeObjectName(MBeanServerConnection conn, String domainName, String typeValue) throws IOException {
        Set<ObjectName> names = QueryMgrImpl.queryJ2EETypeObjectNameSet(conn, domainName, typeValue);
        if (names.size() != 1) {
            throw new IllegalArgumentException("request was for a single Object name of type: " + typeValue + " but found several: " + SmartStringifier.toString(names));
        }
        ObjectName objectName = (ObjectName)SetUtil.getSingleton(names);
        return objectName;
    }

    public static Set<ObjectName> queryJ2EETypeObjectNameSet(MBeanServerConnection conn, String domainName, String typeValue) throws IOException {
        String prop = Util.makeTypeProp((String)typeValue);
        ObjectName pat = Util.newObjectNamePattern((String)domainName, (String)prop);
        Set<ObjectName> names = QueryMgrImpl.queryPatternObjectNameSet(conn, pat);
        return QueryMgrImpl.checked(names);
    }

    public Set<ObjectName> queryJ2EETypesObjectNameSet(Set<String> types) throws IOException {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (String type : types) {
            result.addAll(this.queryJ2EETypeObjectNameSet(type));
        }
        return result;
    }

    public ObjectName querySingletonJ2EEType(String typeValue) {
        Set<ObjectName> names = this.queryJ2EETypeObjectNameSet(typeValue);
        if (names.size() > 1) {
            this.trace("QueryMgrImpl.getJ2EETypeObjectName: expected 1, got " + names.size());
            throw new IllegalArgumentException(typeValue);
        }
        ObjectName objectName = names.size() == 0 ? null : (ObjectName)SetUtil.getSingleton(names);
        return objectName;
    }

    public Set<ObjectName> queryJ2EETypeObjectNameSet(String typeValue) {
        String prop = Util.makeTypeProp((String)typeValue);
        ObjectName pat = Util.newObjectNamePattern((String)this.getJMXDomain(), (String)prop);
        Set<ObjectName> names = QueryMgrImpl.queryPropsObjectNameSet(this.getMBeanServer(), this.getJMXDomain(), prop);
        return names;
    }

    public Set<ObjectName> queryJ2EENameObjectNameSet(String nameValue) {
        String prop = Util.makeNameProp((String)nameValue);
        Set<ObjectName> names = QueryMgrImpl.queryPropsObjectNameSet(this.getMBeanServer(), this.getJMXDomain(), prop);
        return names;
    }

    public static Set<ObjectName> queryPatternObjectNameSet(MBeanServerConnection conn, ObjectName pattern) throws IOException {
        Set names = JMXUtil.queryNames((MBeanServerConnection)conn, (ObjectName)pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public static Set<ObjectName> queryPatternObjectNameSet(MBeanServer server, ObjectName pattern) {
        Set names = JMXUtil.queryNames((MBeanServer)server, (ObjectName)pattern, null);
        return QueryMgrImpl.checked(names);
    }

    public Set<ObjectName> queryPatternObjectNameSet(ObjectName pattern) {
        return QueryMgrImpl.queryPatternObjectNameSet(this.getMBeanServer(), pattern);
    }

    public Set<ObjectName> queryPatternObjectNameSet(String domain, String props) {
        String myDomain = this.getObjectName().getDomain();
        ObjectName pattern = Util.newObjectNamePattern((String)(domain == null ? myDomain : domain), (String)props);
        return QueryMgrImpl.queryPatternObjectNameSet(this.getMBeanServer(), pattern);
    }

    public String[] queryJ2EETypeNames(String type) {
        String prop = Util.makeTypeProp((String)type);
        Set<ObjectName> objectNameSet = this.queryPropsObjectNameSet(prop);
        ObjectName[] objectNames = JMXUtil.objectNameSetToArray(objectNameSet);
        String[] nameKeyValues = JMXUtil.getKeyProperty((String)"name", (ObjectName[])objectNames);
        return nameKeyValues;
    }

    public Set<ObjectName> queryJ2EETypeNameObjectNameSet(String type, String name) {
        String props = Util.makeRequiredProps((String)type, (String)name);
        return this.queryPatternObjectNameSet(Util.newObjectNamePattern((String)this.getObjectName().getDomain(), (String)props));
    }

    private static String[] convertToRegex(String[] wildExprs) {
        String[] regexExprs = null;
        if (wildExprs != null) {
            regexExprs = new String[wildExprs.length];
            for (int i = 0; i < wildExprs.length; ++i) {
                String regex;
                String expr = wildExprs[i];
                regexExprs[i] = regex = expr == null ? null : RegexUtil.wildcardToJavaRegex((String)expr);
            }
        }
        return regexExprs;
    }

    private Set<ObjectName> matchWild(Set<ObjectName> candidates, String[] wildKeys, String[] wildValues) {
        String[] regexNames = QueryMgrImpl.convertToRegex(wildKeys);
        String[] regexValues = QueryMgrImpl.convertToRegex(wildValues);
        ObjectNameQueryImpl query = new ObjectNameQueryImpl();
        Set resultSet = query.matchAll(candidates, regexNames, regexValues);
        return resultSet;
    }

    public Set<ObjectName> queryWildObjectNameSet(String[] wildKeys, String[] wildValues) {
        Set<ObjectName> candidates = this.queryAllObjectNameSet();
        return this.matchWild(candidates, wildKeys, wildValues);
    }

    public Set<ObjectName> queryAllObjectNameSet() {
        ObjectName pat = Util.newObjectNamePattern((String)this.getJMXDomain(), (String)"");
        return this.queryPatternObjectNameSet(pat);
    }

    private Set<ObjectName> queryInterfaceObjectNameSet(Set<ObjectName> objectNames, String interfaceName, String attributeName) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        MBeanServer server = this.getMBeanServer();
        for (ObjectName objectName : objectNames) {
            try {
                if (!server.getAttribute(objectName, attributeName).equals(interfaceName)) continue;
                result.add(objectName);
            }
            catch (JMException e) {}
        }
        return QueryMgrImpl.checked(result);
    }

    public Set<ObjectName> queryInterfaceObjectNameSet(String searchInterfaceName, Set<ObjectName> candidates) throws ClassNotFoundException {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        Set<ObjectName> iter = candidates == null ? this.queryAllObjectNameSet() : candidates;
        Class searchInterface = ClassUtil.getClassFromName((String)searchInterfaceName);
        MBeanServer server = this.getMBeanServer();
        for (ObjectName objectName : iter) {
            try {
                MBeanInfo info = server.getMBeanInfo(objectName);
                String interfaceName = AMXProxyHandler.interfaceName((MBeanInfo)info);
                Class c = ClassUtil.getClassFromName((String)interfaceName);
                if (!searchInterface.isAssignableFrom(c)) continue;
                result.add(objectName);
            }
            catch (JMException e) {}
        }
        return QueryMgrImpl.checked(result);
    }
}

