/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import com.sun.mojarra.scales.component.MultiFileUpload;
import com.sun.mojarra.scales.model.FileHolder;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public final class MultiFileUploadPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent e) {
    }

    public void afterPhase(PhaseEvent e) {
        FacesContext context;
        HttpServletRequest request;
        String uri;
        PhaseId phase = e.getPhaseId();
        if (phase == PhaseId.RESTORE_VIEW && (uri = (request = (HttpServletRequest)(context = FacesContext.getCurrentInstance()).getExternalContext().getRequest()).getRequestURI()) != null && uri.indexOf("/mojarra___MultiFileUpload__fileupload") > -1) {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String clientId = request.getParameter("componentId");
            MultiFileUpload comp = (MultiFileUpload)((Object)request.getSession().getAttribute("HtmlMultiFileUpload-" + clientId));
            request.getSession().setAttribute("HtmlMultiFileUpload-" + clientId, null);
            try {
                String destinationUrl;
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                List items = upload.parseRequest(request);
                FileHolder fileHolder = comp.getFileHolder();
                if (fileHolder != null) {
                    for (int i = 0; i < items.size(); ++i) {
                        FileItem item = (FileItem)items.get(i);
                        fileHolder.addFile(item.getName(), item.getInputStream());
                    }
                }
                if (!(destinationUrl = comp.getDestinationUrl()).startsWith("http")) {
                    if (destinationUrl.charAt(0) != '/') {
                        destinationUrl = "/" + destinationUrl;
                    }
                    destinationUrl = response.encodeURL(context.getApplication().getViewHandler().getActionURL(context, destinationUrl));
                }
                response.setContentType("text/text");
                response.getOutputStream().write(destinationUrl.getBytes());
                context.responseComplete();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                try {
                    String message = e1.getLocalizedMessage();
                    response.sendError(500, e1.getLocalizedMessage());
                }
                catch (IOException ex) {
                    Logger.getLogger(MultiFileUploadPhaseListener.class.getName()).log(Level.SEVERE, null, ex);
                }
                context.responseComplete();
            }
        }
    }
}

