/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.monitor.impl;

import com.sun.enterprise.web.monitor.PwcServletStats;
import com.sun.enterprise.web.monitor.impl.MonitorUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class PwcServletStatsImpl
implements PwcServletStats {
    private transient MBeanServer server;
    private ObjectName servletObjName;

    public PwcServletStatsImpl(String domain, String vsId, String contextPath, String servletName, String appName, String serverName) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        String objNameStr = domain + ":j2eeType=Servlet" + ",name=" + servletName + ",WebModule=" + this.createTomcatWebModuleName(vsId, contextPath) + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName;
        try {
            this.servletObjName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.objectNameCreationError", new Object[]{objNameStr}, t);
        }
    }

    public long getMaxTimeMillis() {
        return this.getLongValue(this.queryStatistic(this.servletObjName, "maxTimeMillis"));
    }

    public long getMinTimeMillis() {
        return this.getLongValue(this.queryStatistic(this.servletObjName, "minTimeMillis"));
    }

    public long getProcessingTimeMillis() {
        return this.getLongValue(this.queryStatistic(this.servletObjName, "processingTimeMillis"));
    }

    public int getRequestCount() {
        return this.getIntValue(this.queryStatistic(this.servletObjName, "requestCount"));
    }

    public int getErrorCount() {
        return this.getIntValue(this.queryStatistic(this.servletObjName, "errorCount"));
    }

    private Object queryStatistic(ObjectName on, String attrName) {
        Object resultObj = null;
        try {
            resultObj = this.server.getAttribute(on, attrName);
        }
        catch (Throwable t) {
            MonitorUtil.log(Level.SEVERE, "pwc.monitoring.queryError", new Object[]{attrName, on}, t);
        }
        return resultObj;
    }

    private String createTomcatWebModuleName(String vsId, String contextPath) {
        String PREFIX = "//";
        String tcWebModuleName = contextPath != null && !contextPath.equals("") ? "//" + vsId + contextPath : "//" + vsId + "/";
        return tcWebModuleName;
    }

    private long getLongValue(Object resultObj) {
        long result = 0L;
        if (resultObj != null) {
            Long countObj = (Long)resultObj;
            result = countObj;
        }
        return result;
    }

    private int getIntValue(Object resultObj) {
        int result = 0;
        if (resultObj != null) {
            Integer countObj = (Integer)resultObj;
            result = countObj;
        }
        return result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
    }
}

