/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.logging.Level;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;
import org.glassfish.web.valve.GlassFishValveAdapter;
import org.glassfish.web.valve.TomcatValveAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardPipeline
implements Pipeline,
Contained,
Lifecycle {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(StandardPipeline.class.getName());
    protected GlassFishValve basic = null;
    protected Container container = null;
    protected int debug = 0;
    protected String info = "org.apache.catalina.core.StandardPipeline/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected GlassFishValve[] valves = new GlassFishValve[0];
    private Valve firstTcValve;
    private Valve lastTcValve;

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        for (int i = 0; i < this.valves.length; ++i) {
            if (!(this.valves[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.valves[i])).start();
        }
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.notStarted"));
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).stop();
        }
        for (int i = 0; i < this.valves.length; ++i) {
            if (!(this.valves[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.valves[i])).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    @Override
    public GlassFishValve getBasic() {
        return this.basic;
    }

    @Override
    public void setBasic(GlassFishValve valve) {
        GlassFishValve oldBasic = this.basic;
        if (oldBasic == valve) {
            return;
        }
        if (oldBasic != null) {
            if (this.started && oldBasic instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldBasic)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "StandardPipeline.setBasic: stop", e);
                }
            }
            if (oldBasic instanceof Contained) {
                try {
                    ((Contained)((Object)oldBasic)).setContainer(null);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "StandardPipeline.setBasic: start", e);
                return;
            }
        }
        this.basic = valve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValve(GlassFishValve valve) {
        if (this.firstTcValve != null) {
            this.addValve(new TomcatValveAdapter(valve));
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "StandardPipeline.addValve: start: ", e);
            }
        }
        GlassFishValve[] glassFishValveArray = this.valves;
        synchronized (this.valves) {
            GlassFishValve[] results = new GlassFishValve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = valve;
            this.valves = results;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized void addValve(Valve valve) {
        if (this.isGlassFishValve(valve)) {
            try {
                this.addValve(new GlassFishValveAdapter(valve));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to add valve " + valve, e);
            }
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "StandardPipeline.addValve: start: ", e);
            }
        }
        if (this.firstTcValve == null) {
            this.firstTcValve = this.lastTcValve = valve;
        } else {
            this.lastTcValve.setNext(valve);
            this.lastTcValve = valve;
        }
        if (this.basic != null) {
            valve.setNext((Valve)((Object)this.basic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlassFishValve[] getValves() {
        if (this.basic == null) {
            return this.valves;
        }
        GlassFishValve[] glassFishValveArray = this.valves;
        synchronized (this.valves) {
            GlassFishValve[] results = new GlassFishValve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = this.basic;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return results;
        }
    }

    @Override
    public boolean hasNonBasicValves() {
        return this.valves != null && this.valves.length > 0;
    }

    public ObjectName[] getValveObjectNames() {
        ObjectName[] oname = new ObjectName[this.valves.length + 1];
        for (int i = 0; i < this.valves.length; ++i) {
            if (!(this.valves[i] instanceof ValveBase)) continue;
            oname[i] = ((ValveBase)this.valves[i]).getObjectName();
        }
        if (this.basic instanceof ValveBase) {
            oname[this.valves.length] = ((ValveBase)this.basic).getObjectName();
        }
        return oname;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        GlassFishValve[] savedValves;
        if (this.valves.length > 0 || this.basic != null) {
            int status = 1;
            for (int i = 0; i < this.valves.length && (status = this.valves[i].invoke(request, response)) == 1; ++i) {
            }
            savedValves = this.valves;
            if (status == 1) {
                if (this.firstTcValve != null) {
                    this.firstTcValve.invoke((org.apache.catalina.connector.Request)request, (org.apache.catalina.connector.Response)response);
                } else if (this.basic != null) {
                    this.basic.invoke(request, response);
                    this.basic.postInvoke(request, response);
                }
            }
            for (int j = i - 1; j >= 0; --j) {
                savedValves[j].postInvoke(request, response);
            }
        } else {
            throw new ServletException(sm.getString("standardPipeline.noValve"));
        }
        savedValves = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValve(GlassFishValve valve) {
        GlassFishValve[] glassFishValveArray = this.valves;
        synchronized (this.valves) {
            int j = -1;
            for (int i = 0; i < this.valves.length; ++i) {
                if (valve != this.valves[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            GlassFishValve[] results = new GlassFishValve[this.valves.length - 1];
            int n = 0;
            for (int i = 0; i < this.valves.length; ++i) {
                if (i == j) continue;
                results[n++] = this.valves[i];
            }
            this.valves = results;
            try {
                if (valve instanceof Contained) {
                    ((Contained)((Object)valve)).setContainer(null);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.started && valve instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)valve)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, "StandardPipeline.removeValve: stop: ", e);
                }
            }
            return;
        }
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + message);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + message, throwable);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private boolean isGlassFishValve(Valve valve) {
        try {
            Method m = valve.getClass().getMethod("invoke", Request.class, Response.class);
            return m != null && Integer.TYPE.equals(m.getReturnType()) && !Modifier.isAbstract(m.getModifiers());
        }
        catch (Exception e) {
            return false;
        }
    }
}

