/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.config.Property;
import org.glassfish.javaee.services.ResourcesBinder;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourceManager
implements Startup,
PostConstruct,
PreDestroy,
ConfigListener {
    @Inject
    private Logger logger;
    @Inject
    private ResourcesBinder resourcesBinder;
    @Inject
    private Habitat connectorRuntimeHabitat;
    @Inject
    private Resources allResources;
    @Inject
    private Habitat deployerHabitat;
    private ConnectorRuntime runtime;

    public void postConstruct() {
        this.deployResources(this.allResources.getResources());
    }

    public void deployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            if (!(resource instanceof BindableResource)) continue;
            BindableResource bindableResource = (BindableResource)resource;
            this.resourcesBinder.deployResource(bindableResource.getJndiName(), resource);
        }
        this.addListenerToResources(resources);
    }

    public Resources getAllResources() {
        return this.allResources;
    }

    public void preDestroy() {
        Collection resources = ConnectorsUtil.getAllSystemRAResourcesAndPools((Resources)this.allResources);
        this.undeployResources(resources);
        this.getConnectorRuntime().shutdownAllActiveResourceAdapters(null);
        this.removeListenerFromResources();
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class, null);
        }
        return this.runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            try {
                this.getResourceDeployer(resource).undeployResource((Object)resource);
            }
            catch (Exception e) {
                this.logger.warning("Unable to undeploy resource of type : " + resource.getClass().getName());
            }
            finally {
                this.removeListenerFromResource(resource);
            }
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unprocessed = ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                NotProcessed np = null;
                switch (type) {
                    case ADD: {
                        ResourceManager.this.logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                        np = this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        ResourceManager.this.logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        ResourceManager.this.logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        np = this.handleRemoveEvent(changedInstance);
                        break;
                    }
                    default: {
                        np = new NotProcessed("Unrecognized type of change: " + type);
                    }
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
                NotProcessed np = null;
                try {
                    if (ConnectorsUtil.isValidEventType(instance)) {
                        ResourceDeployer deployer = ResourceManager.this.getResourceDeployer(instance);
                        if (deployer != null) {
                            deployer.redeployResource(instance);
                        } else {
                            ResourceManager.this.logger.warning("no deployer found for resource type [ " + instance.getClass().getName() + "]");
                        }
                    } else if (ConnectorsUtil.isValidEventType((Object)instance.getParent())) {
                        ResourceDeployer deployer = ResourceManager.this.getResourceDeployer(instance);
                        if (deployer != null) {
                            deployer.redeployResource((Object)instance.getParent());
                        } else {
                            ResourceManager.this.logger.warning("no deployer found for resource type [ " + instance.getClass().getName() + "]");
                        }
                    }
                }
                catch (Exception ex) {
                    String msg = ResourceManager.class.getName() + " : Error while handling change Event";
                    ResourceManager.this.logger.severe(msg);
                    np = new NotProcessed(msg);
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
                NotProcessed np = null;
                ResourceManager.this.addListenerToResource(instance);
                if (instance instanceof BindableResource) {
                    ResourceManager.this.resourcesBinder.deployResource(((BindableResource)instance).getJndiName(), (Resource)instance);
                } else if (!(instance instanceof ConnectorConnectionPool) && !(instance instanceof JdbcConnectionPool)) {
                    if (instance instanceof Property) {
                        Property prop = (Property)instance;
                        np = new NotProcessed("ResourceManager: a property was added: " + prop.getName() + "=" + prop.getValue());
                    } else {
                        np = new NotProcessed("ResourceManager: configuration " + Dom.unwrap(instance).getProxyType().getName() + " was added");
                    }
                }
                return np;
            }

            private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
                ArrayList<T> instancesToDestroy = new ArrayList<T>();
                NotProcessed np = null;
                try {
                    if (ConnectorsUtil.isValidEventType(instance)) {
                        instancesToDestroy.add(instance);
                        ResourceManager.this.removeListenerFromResource(instance);
                        ResourceDeployer deployer = ResourceManager.this.getResourceDeployer(instance);
                        if (deployer != null) {
                            deployer.undeployResource(instance);
                        } else {
                            ResourceManager.this.logger.warning("no deployer found for resource type [ " + instance.getClass().getName() + "]");
                        }
                    } else if (ConnectorsUtil.isValidEventType((Object)instance.getParent())) {
                        ResourceDeployer deployer = ResourceManager.this.getResourceDeployer(instance);
                        if (deployer != null) {
                            deployer.redeployResource((Object)instance.getParent());
                        } else {
                            ResourceManager.this.logger.warning("no deployer found for resource type [ " + instance.getClass().getName() + "]");
                        }
                    }
                }
                catch (Exception ex) {
                    String msg = ResourceManager.class.getName() + " : Error while handling remove Event";
                    ResourceManager.this.logger.severe(msg);
                    np = new NotProcessed(msg);
                }
                return np;
            }
        }, (Logger)this.logger);
        return unprocessed;
    }

    private void addListenerToResources(Collection<Resource> resources) {
        for (Resource configuredResource : resources) {
            this.addListenerToResource(configuredResource);
        }
    }

    private void addListenerToResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        }
    }

    private void removeListenerFromResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        }
    }

    private void removeListenerFromResources() {
        for (Resource configuredResource : this.allResources.getResources()) {
            this.removeListenerFromResource(configuredResource);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = this.deployerHabitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }
}

