/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.mgbean.ManagedBeanInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.ApplicationScoped;
import javax.faces.model.ManagedBean;
import javax.faces.model.ManagedProperty;
import javax.faces.model.NoneScoped;
import javax.faces.model.RequestScoped;
import javax.faces.model.SessionScoped;
import javax.faces.model.ViewScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanConfigHandler
implements ConfigAnnotationHandler {
    private static final Class<?>[] SCOPES = new Class[]{RequestScoped.class, ViewScoped.class, SessionScoped.class, ApplicationScoped.class, NoneScoped.class};
    private static final Collection<Class<? extends Annotation>> HANDLES;
    private Map<Class<?>, Annotation> managedBeans;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (this.managedBeans == null) {
            this.managedBeans = new HashMap();
        }
        this.managedBeans.put(target, annotation);
    }

    @Override
    public void push(FacesContext ctx) {
        ApplicationAssociate associate;
        if (this.managedBeans != null && (associate = ApplicationAssociate.getInstance(ctx.getExternalContext())) != null) {
            BeanManager manager = associate.getBeanManager();
            for (Map.Entry<Class<?>, Annotation> entry : this.managedBeans.entrySet()) {
                this.process(manager, entry.getKey(), entry.getValue());
            }
        }
    }

    private void process(BeanManager manager, Class<?> annotatedClass, Annotation annotation) {
        manager.register(this.getBeanInfo(annotatedClass, (ManagedBean)annotation));
    }

    private ManagedBeanInfo getBeanInfo(Class<?> annotatedClass, ManagedBean metadata) {
        String name = this.getName(metadata, annotatedClass);
        String scope = this.getScope(annotatedClass);
        boolean eager = metadata.eager();
        Field[] fields = annotatedClass.getDeclaredFields();
        ArrayList<ManagedBeanInfo.ManagedProperty> properties = null;
        if (fields.length > 0) {
            for (Field field : fields) {
                String n;
                ManagedProperty property = field.getAnnotation(ManagedProperty.class);
                if (property == null) continue;
                if (properties == null) {
                    properties = new ArrayList<ManagedBeanInfo.ManagedProperty>();
                }
                ManagedBeanInfo.ManagedProperty propertyInfo = new ManagedBeanInfo.ManagedProperty((n = property.name()) != null && n.length() != 0 ? n : field.getName(), field.getType().getName(), property.value(), null, null);
                properties.add(propertyInfo);
            }
        }
        return new ManagedBeanInfo(name, annotatedClass.getName(), scope, eager, null, null, properties, null);
    }

    private String getScope(Class<?> annotatedClass) {
        for (Class<?> scope : SCOPES) {
            Object a = annotatedClass.getAnnotation(scope);
            if (a == null) continue;
            if (a instanceof RequestScoped) {
                return "request";
            }
            if (a instanceof ViewScoped) {
                return "view";
            }
            if (a instanceof SessionScoped) {
                return "session";
            }
            if (a instanceof ApplicationScoped) {
                return "application";
            }
            if (!(a instanceof NoneScoped)) continue;
            return "none";
        }
        return "request";
    }

    private String getName(ManagedBean managedBean, Class<?> annotatedClass) {
        String name = managedBean.name();
        if (name.length() == 0) {
            String t = annotatedClass.getName();
            name = t.substring(t.lastIndexOf(46) + 1);
            char[] nameChars = name.toCharArray();
            nameChars[0] = Character.toLowerCase(nameChars[0]);
            name = new String(nameChars);
        }
        return name;
    }

    static {
        ArrayList<Class<ManagedBean>> handles = new ArrayList<Class<ManagedBean>>(2);
        handles.add(ManagedBean.class);
        HANDLES = Collections.unmodifiableCollection(handles);
    }
}

