/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsMappingProject;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.Project;
import org.xml.sax.SAXException;

public class XMLEntityMappingsReader {
    public static final String ORM_1_0_XSD = "org/eclipse/persistence/jpa/orm_1_0.xsd";
    public static final String ORM_1_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ORM_2_0_XSD = "org/eclipse/persistence/jpa/orm_2_0.xsd";
    public static final String ORM_2_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ECLIPSELINK_ORM_XSD = "xsd/eclipselink_orm_1_1.xsd";
    public static final String ECLIPSELINK_ORM_NAMESPACE = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    private static XMLContext m_orm1_0Project;
    private static XMLContext m_orm2_0Project;
    private static XMLContext m_eclipseLinkOrmProject;

    protected static XMLEntityMappings read(URL mappingFileUrl, Reader reader1, Reader reader2, Reader reader3, ClassLoader classLoader) {
        XMLEntityMappings xmlEntityMappings;
        if (m_orm1_0Project == null) {
            m_orm1_0Project = new XMLContext((Project)new XMLEntityMappingsMappingProject("http://java.sun.com/xml/ns/persistence/orm", ORM_1_0_XSD));
            m_orm2_0Project = new XMLContext((Project)new XMLEntityMappingsMappingProject("http://java.sun.com/xml/ns/persistence/orm", ORM_2_0_XSD));
            m_eclipseLinkOrmProject = new XMLContext((Project)new XMLEntityMappingsMappingProject(ECLIPSELINK_ORM_NAMESPACE, ECLIPSELINK_ORM_XSD));
        }
        try {
            XMLUnmarshaller unmarshaller = m_orm2_0Project.createUnmarshaller();
            XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, ORM_2_0_XSD);
            xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader1);
        }
        catch (Exception eee) {
            try {
                XMLUnmarshaller unmarshaller = m_orm1_0Project.createUnmarshaller();
                XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, ORM_1_0_XSD);
                xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader2);
            }
            catch (Exception e) {
                try {
                    XMLUnmarshaller unmarshaller = m_eclipseLinkOrmProject.createUnmarshaller();
                    XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, ECLIPSELINK_ORM_XSD);
                    xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader3);
                }
                catch (Exception ee) {
                    throw ValidationException.errorParsingMappingFile((URL)mappingFileUrl, (Exception)ee);
                }
            }
        }
        return xmlEntityMappings;
    }

    private static InputStreamReader getInputStreamReader(URL url) throws IOException {
        URLConnection cnx1 = url.openConnection();
        cnx1.setUseCaches(false);
        return new InputStreamReader(cnx1.getInputStream(), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEntityMappings read(URL url, ClassLoader classLoader) throws IOException {
        InputStreamReader reader1 = null;
        InputStreamReader reader2 = null;
        InputStreamReader reader3 = null;
        try {
            try {
                reader1 = XMLEntityMappingsReader.getInputStreamReader(url);
                reader2 = XMLEntityMappingsReader.getInputStreamReader(url);
                reader3 = XMLEntityMappingsReader.getInputStreamReader(url);
            }
            catch (UnsupportedEncodingException exception) {
                throw ValidationException.fatalErrorOccurred((Exception)exception);
            }
            XMLEntityMappings entityMappings = XMLEntityMappingsReader.read(url, reader1, reader2, reader3, classLoader);
            entityMappings.setMappingFile(url);
            XMLEntityMappings xMLEntityMappings = entityMappings;
            return xMLEntityMappings;
        }
        finally {
            try {
                if (reader1 != null) {
                    reader1.close();
                }
                if (reader2 != null) {
                    reader2.close();
                }
                if (reader3 != null) {
                    reader3.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void useLocalSchemaForUnmarshaller(XMLUnmarshaller unmarshaller, String schemaName) throws IOException, SAXException {
        URL url = XMLEntityMappingsReader.class.getClassLoader().getResource(schemaName);
        InputStream schemaStream = url.openStream();
        StreamSource source = new StreamSource(url.openStream());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(source);
        try {
            unmarshaller.setSchema(schema);
        }
        catch (UnsupportedOperationException ex) {
            unmarshaller.setValidationMode(3);
        }
        finally {
            schemaStream.close();
        }
    }
}

