/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.FilterRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;

public class FilterRegistrationImpl
extends FilterRegistration {
    private StandardContext ctx;
    private FilterDef filterDef;

    FilterRegistrationImpl(StandardContext ctx, String filterName, String className) {
        this.ctx = ctx;
        this.filterDef = new FilterDef();
        this.filterDef.setFilterName(filterName);
        this.filterDef.setFilterClass(className);
        ctx.addFilterDef(this.filterDef);
    }

    public void setDescription(String description) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException("ServletContext.already initialized");
        }
        super.setDescription(description);
        this.filterDef.setDescription(description);
    }

    public void setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException("ServletContext.already initialized");
        }
        if (null != value) {
            this.filterDef.addInitParameter(name, value);
        } else {
            this.filterDef.removeInitParameter(name);
        }
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException("ServletContext.already initialized");
        }
        super.setAsyncSupported(isAsyncSupported);
        this.filterDef.setIsAsyncSupported(isAsyncSupported);
    }
}

