/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.ServletRegistration;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;

public class ServletRegistrationImpl
extends ServletRegistration {
    private StandardContext ctx;
    private Wrapper wrapper;

    ServletRegistrationImpl(StandardContext ctx, String servletName, String className) {
        this.ctx = ctx;
        this.wrapper = ctx.createWrapper();
        this.wrapper.setName(servletName);
        this.wrapper.setServletClass(className);
        ctx.addChild(this.wrapper);
    }

    public void setDescription(String description) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException("ServletContext.already initialized");
        }
        super.setDescription(description);
        this.wrapper.setDescription(description);
    }

    public void setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException("ServletContext.already initialized");
        }
        if (null != value) {
            this.wrapper.addInitParameter(name, value);
        } else {
            this.wrapper.removeInitParameter(name);
        }
    }

    public void setLoadOnStartup(int loadOnStartup) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException("ServletContext.already initialized");
        }
        super.setLoadOnStartup(loadOnStartup);
        this.wrapper.setLoadOnStartup(loadOnStartup);
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException("ServletContext.already initialized");
        }
        super.setAsyncSupported(isAsyncSupported);
        this.wrapper.setIsAsyncSupported(isAsyncSupported);
    }
}

