/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RootDeploymentDescriptor
extends Descriptor {
    private static final double ANNOTATION_EJB_VER = 3.0;
    private static final double ANNOTATION_WAR_VER = 2.5;
    private static final double ANNOTATION_CAR_VER = 5.0;
    protected String moduleID;
    private String specVersion;
    private String index = null;
    protected transient ClassLoader classLoader = null;
    protected Map<Class<? extends RootDeploymentDescriptor>, List<RootDeploymentDescriptor>> extensions = new HashMap<Class<? extends RootDeploymentDescriptor>, List<RootDeploymentDescriptor>>();
    protected ModuleDescriptor moduleDescriptor;
    private boolean fullFlag = false;
    private boolean fullAttribute = false;
    private static final List<?> emptyList = new ArrayList();

    public RootDeploymentDescriptor() {
    }

    public RootDeploymentDescriptor(String name, String description) {
        super(name, description);
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    public abstract String getModuleID();

    public abstract String getDefaultSpecVersion();

    public abstract boolean isEmpty();

    public String getSpecVersion() {
        if (this.specVersion == null) {
            this.specVersion = this.getDefaultSpecVersion();
        }
        try {
            Double.parseDouble(this.specVersion);
        }
        catch (NumberFormatException nfe) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "invalidSpecVersion", new Object[]{this.specVersion, this.getDefaultSpecVersion()});
            this.specVersion = this.getDefaultSpecVersion();
        }
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public abstract XModuleType getModuleType();

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public abstract ClassLoader getClassLoader();

    @Override
    public void setDisplayName(String name) {
        super.setName(name);
    }

    @Override
    public String getDisplayName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        this.setModuleID(name);
    }

    @Override
    public String getName() {
        if (this.getModuleID() != null) {
            return this.getModuleID();
        }
        return this.getDisplayName();
    }

    public void setSchemaLocation(String schemaLocation) {
        this.addExtraAttribute("schema-location", schemaLocation);
    }

    public String getSchemaLocation() {
        return (String)this.getExtraAttribute("schema-location");
    }

    public ModuleDescriptor getModuleDescriptor() {
        if (this.moduleDescriptor == null) {
            this.moduleDescriptor = new ModuleDescriptor();
            this.moduleDescriptor.setModuleType(this.getModuleType());
            this.moduleDescriptor.setDescriptor(this);
        }
        return this.moduleDescriptor;
    }

    public void setModuleDescriptor(ModuleDescriptor descriptor) {
        this.moduleDescriptor = descriptor;
        for (List<RootDeploymentDescriptor> extByType : this.extensions.values()) {
            if (extByType == null) continue;
            for (RootDeploymentDescriptor ext : extByType) {
                ext.setModuleDescriptor(descriptor);
            }
        }
    }

    public abstract boolean isApplication();

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n Module Type = ").append(this.getModuleType());
        toStringBuffer.append("\n Module spec version = ").append(this.getSpecVersion());
        if (this.moduleID != null) {
            toStringBuffer.append("\n Module ID = ").append(this.moduleID);
        }
        if (this.getSchemaLocation() != null) {
            toStringBuffer.append("\n Client SchemaLocation = ").append(this.getSchemaLocation());
        }
    }

    public Collection<RootDeploymentDescriptor> getExtensionsDescriptors() {
        ArrayList<RootDeploymentDescriptor> flattened = new ArrayList<RootDeploymentDescriptor>();
        for (List<RootDeploymentDescriptor> extensionsByType : this.extensions.values()) {
            flattened.addAll(extensionsByType);
        }
        return Collections.unmodifiableCollection(flattened);
    }

    public <T extends RootDeploymentDescriptor> Collection<T> getExtensionsDescriptors(Class<T> type) {
        if (this.extensions.containsKey(type)) {
            return Collections.unmodifiableCollection((Collection)this.extensions.get(type));
        }
        return emptyList;
    }

    public <T extends RootDeploymentDescriptor> T getExtensionsDescriptors(Class<? extends RootDeploymentDescriptor> type, String index) {
        for (RootDeploymentDescriptor rootDeploymentDescriptor : this.getExtensionsDescriptors(type)) {
            if (!(index == null ? rootDeploymentDescriptor.index == null : index.equals(rootDeploymentDescriptor.index))) continue;
            return (T)rootDeploymentDescriptor;
        }
        return null;
    }

    public synchronized <T extends RootDeploymentDescriptor> void addExtensionDescriptor(Class<? extends RootDeploymentDescriptor> type, T instance, String index) {
        List<Object> values;
        if (this.extensions.containsKey(type)) {
            values = this.extensions.get(type);
        } else {
            values = new ArrayList();
            this.extensions.put(type, values);
        }
        instance.index = index;
        values.add(instance);
    }

    public void setFullFlag(boolean flag) {
        this.fullFlag = flag;
    }

    public void setFullAttribute(String value) {
        this.fullAttribute = Boolean.valueOf(value);
    }

    public boolean isFullAttribute() {
        return this.fullAttribute;
    }

    public boolean isFullFlag() {
        if (this.fullAttribute || this.fullFlag) {
            return true;
        }
        return this.isDDWithNoAnnotationAllowed();
    }

    public boolean isDDWithNoAnnotationAllowed() {
        XModuleType mType = this.getModuleType();
        double specVersion = Double.parseDouble(this.getSpecVersion());
        if (XModuleType.RAR == mType) {
            return true;
        }
        return mType.equals(ModuleType.EJB) && specVersion < 3.0 || mType.equals(ModuleType.WAR) && specVersion < 2.5 || mType.equals(ModuleType.CAR) && specVersion < 5.0;
    }
}

