/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractWebHandler;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.logging.Level;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.InitParam;
import javax.servlet.annotation.ServletFilter;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ServletFilterHandler
extends AbstractWebHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return ServletFilter.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webCompContexts[0].getDescriptor().getWebBundleDescriptor());
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webBundleContext.getDescriptor());
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleDescriptor webBundleDesc) throws AnnotationProcessorException {
        DispatcherType[] dispatcherTypes;
        String[] servletNames;
        InitParam[] initParams;
        Class filterClass = (Class)ainfo.getAnnotatedElement();
        if (!Filter.class.isAssignableFrom(filterClass)) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.needtoimpl", "The Class {0} having annotation {1} need to implement the interface {2}.", new Object[]{filterClass.getName(), ServletFilter.class.getName(), Filter.class.getName()}));
            return this.getDefaultFailedResult();
        }
        ServletFilter servletFilterAn = (ServletFilter)ainfo.getAnnotation();
        String filterName = servletFilterAn.filterName();
        if (filterName == null || filterName.length() == 0) {
            filterName = filterClass.getName();
        }
        com.sun.enterprise.deployment.web.ServletFilter servletFilterDesc = null;
        for (com.sun.enterprise.deployment.web.ServletFilter sfDesc : webBundleDesc.getServletFilters()) {
            if (!filterName.equals(sfDesc.getName())) continue;
            servletFilterDesc = sfDesc;
            break;
        }
        if (servletFilterDesc == null) {
            servletFilterDesc = new ServletFilterDescriptor();
            servletFilterDesc.setName(filterName);
        } else {
            String filterImpl = servletFilterDesc.getClassName();
            if (filterImpl != null && filterImpl.length() > 0 && !filterImpl.equals(filterClass.getName())) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.filternamedontmatch", "The filter '{0}' has implementation '{1}' in xml. It does not match with '{2}' from annotation @{3}.", new Object[]{filterName, filterImpl, filterClass.getName(), ServletFilter.class.getName()}));
                return this.getDefaultFailedResult();
            }
        }
        servletFilterDesc.setClassName(filterClass.getName());
        if (servletFilterDesc.getDescription() == null) {
            servletFilterDesc.setDescription(servletFilterAn.description());
        }
        if (servletFilterDesc.getDisplayName() == null) {
            servletFilterDesc.setDisplayName(servletFilterAn.displayName());
        }
        if (servletFilterDesc.getInitializationParameters().size() == 0 && (initParams = servletFilterAn.initParams()) != null && initParams.length > 0) {
            for (InitParam initParam : initParams) {
                servletFilterDesc.addInitializationParameter(new EnvironmentProperty(initParam.name(), initParam.value(), initParam.description()));
            }
        }
        if (servletFilterDesc.getSmallIconUri() == null) {
            servletFilterDesc.setSmallIconUri(servletFilterAn.icon());
        }
        if (servletFilterDesc.getLargeIconUri() == null) {
            servletFilterDesc.setLargeIconUri(servletFilterAn.icon());
        }
        if (servletFilterDesc.isAsyncSupported() == null) {
            servletFilterDesc.setAsyncSupported(servletFilterAn.asyncSupported());
        }
        if (servletFilterDesc.getAsyncTimeout() == null) {
            servletFilterDesc.setAsyncTimeout(servletFilterAn.asyncTimeout());
        }
        ServletFilterMapping servletFilterMappingDesc = null;
        for (ServletFilterMapping sfm : webBundleDesc.getServletFilterMappings()) {
            if (!filterName.equals(sfm.getName())) continue;
            servletFilterMappingDesc = sfm;
            break;
        }
        if (servletFilterMappingDesc == null) {
            servletFilterMappingDesc = new ServletFilterMappingDescriptor();
            servletFilterMappingDesc.setName(filterName);
        }
        if (servletFilterMappingDesc.getURLPatterns().size() == 0) {
            Object[] urlPatterns = servletFilterAn.urlPatterns();
            if (urlPatterns == null || urlPatterns.length == 0) {
                urlPatterns = servletFilterAn.value();
            }
            boolean validUrlPatterns = false;
            if (urlPatterns != null && urlPatterns.length > 0) {
                validUrlPatterns = true;
                for (Object up : urlPatterns) {
                    if (up == null || ((String)up).length() == 0) {
                        validUrlPatterns = false;
                    }
                    servletFilterMappingDesc.addURLPattern((String)up);
                }
            }
            if (!validUrlPatterns) {
                String urlPatternString = urlPatterns != null ? Arrays.toString(urlPatterns) : "";
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidUrlPatterns", "Invalid url patterns: {0}.", new Object[]{urlPatternString}));
            }
        }
        if (servletFilterMappingDesc.getServletNames().size() == 0 && (servletNames = servletFilterAn.servletNames()) != null && servletNames.length > 0) {
            for (String sn : servletNames) {
                servletFilterMappingDesc.addServletName(sn);
            }
        }
        if (servletFilterMappingDesc.getDispatchers().size() == 0 && (dispatcherTypes = servletFilterAn.dispatcherTypes()) != null && dispatcherTypes.length > 0) {
            for (DispatcherType dType : dispatcherTypes) {
                servletFilterMappingDesc.addDispatcher(dType.name());
            }
        }
        webBundleDesc.addServletFilter(servletFilterDesc);
        webBundleDesc.addServletFilterMapping(servletFilterMappingDesc);
        return this.getDefaultProcessedResult();
    }
}

