/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModuleNode
extends DeploymentDescriptorNode {
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("alt-dd", "setAlternateDescriptor");
        table.put("context-root", "setContextRoot");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        ModuleDescriptor descriptor = (ModuleDescriptor)this.getDescriptor();
        if (element.getQName().equals("web-uri")) {
            descriptor.setModuleType(XModuleType.WAR);
            descriptor.setArchiveUri(value);
        } else if (element.getQName().equals("ejb")) {
            descriptor.setModuleType(XModuleType.EJB);
            descriptor.setArchiveUri(value);
        } else if (element.getQName().equals("connector")) {
            descriptor.setModuleType(XModuleType.RAR);
            descriptor.setArchiveUri(value);
        } else if (element.getQName().equals("java")) {
            descriptor.setModuleType(XModuleType.CAR);
            descriptor.setArchiveUri(value);
        } else if (element.getQName().equals("web")) {
            descriptor.setModuleType(XModuleType.WAR);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ModuleDescriptor descriptor) {
        Element module = ModuleNode.appendChild(parent, nodeName);
        if (ModuleType.WAR.equals(descriptor.getModuleType())) {
            Element modType = ModuleNode.appendChild(module, "web");
            ModuleNode.appendTextChild((Node)modType, "web-uri", descriptor.getArchiveUri());
            ModuleNode.forceAppendTextChild(modType, "context-root", descriptor.getContextRoot());
        } else {
            String type = "ejb";
            if (ModuleType.CAR.equals(descriptor.getModuleType())) {
                type = "java";
            } else if (ModuleType.RAR.equals(descriptor.getModuleType())) {
                type = "connector";
            }
            ModuleNode.appendTextChild((Node)module, type, descriptor.getArchiveUri());
        }
        ModuleNode.appendTextChild((Node)module, "alt-dd", descriptor.getAlternateDescriptor());
        return module;
    }
}

