/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.ClientJarMaker;
import com.sun.enterprise.deployment.backend.ClientJarMakerUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;

class ModuleClientJarMaker
implements ClientJarMaker {
    protected Properties props;

    public ModuleClientJarMaker(Properties props) {
        this.props = props;
    }

    public void create(RootDeploymentDescriptor descriptor, ReadableArchive source, WritableArchive target, ZipItem[] stubs, Properties props) throws IOException {
        this.create(descriptor, source, null, target, stubs, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(RootDeploymentDescriptor descriptor, ReadableArchive source, ReadableArchive source2, WritableArchive target, ZipItem[] stubs, Properties props) throws IOException {
        ClientJarMakerUtils.populateStubs(target, stubs);
        ReadableArchive appclientSource = null;
        ReadableArchive appclientSource2 = null;
        if (descriptor.isApplication()) {
            List<String> libraries = ClientJarMakerUtils.getLibraryEntries((Application)Application.class.cast(descriptor), source);
            for (String entryName : libraries) {
                ReadableArchive subSource = null;
                try {
                    subSource = source.getSubArchive(entryName);
                    Enumeration subEntries = subSource.entries();
                    while (subEntries.hasMoreElements()) {
                        String subEntryName = (String)String.class.cast(subEntries.nextElement());
                        ClientJarMakerUtils.copy(subSource, target, subEntryName);
                    }
                }
                finally {
                    if (subSource == null) continue;
                    subSource.close();
                }
            }
            for (ModuleDescriptor md : ((Application)Application.class.cast(descriptor)).getModules()) {
                if (!md.getModuleType().equals((Object)ModuleType.CAR)) continue;
                appclientSource = source.getSubArchive(md.getArchiveUri());
                if (source2 != null) {
                    appclientSource2 = source2.getSubArchive(md.getArchiveUri());
                }
                break;
            }
        } else {
            appclientSource = source;
            appclientSource2 = source2;
        }
        if (appclientSource != null) {
            ClientJarMakerUtils.populateModuleJar(appclientSource, appclientSource2, target);
        } else {
            ClientJarMakerUtils.copyDeploymentDescriptors((Archivist)new ApplicationArchivist(), source, source2, target);
        }
        if (descriptor.isApplication()) {
            for (ModuleDescriptor md : ((Application)Application.class.cast(descriptor)).getModules()) {
                if (!md.getModuleType().equals((Object)ModuleType.EJB)) continue;
                ReadableArchive subSource = source.getSubArchive(md.getArchiveUri());
                Enumeration e = subSource.entries();
                while (e.hasMoreElements()) {
                    String entryName = (String)String.class.cast(e.nextElement());
                    if (!entryName.endsWith(".class")) continue;
                    try {
                        ClientJarMakerUtils.copy(subSource, target, entryName);
                    }
                    catch (IOException ioe) {}
                    continue;
                    finally {
                        if (subSource == null) continue;
                        subSource.close();
                    }
                }
            }
        }
    }
}

