/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DolProvider
implements ApplicationMetaDataProvider<Application> {
    @Inject
    ArchivistFactory archivistFactory;
    @Inject(name="application_deploy", optional=true)
    protected ApplicationVisitor deploymentVisitor = null;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    protected ArchiveFactory archiveFactory;

    public MetaData getMetaData() {
        return null;
    }

    public Application load(DeploymentContext dc, Object defaultValue) throws IOException {
        Application application;
        ReadableArchive sourceArchive = dc.getSource();
        ClassLoader cl = dc.getClassLoader();
        Properties props = dc.getCommandParameters();
        String name = props.getProperty("name");
        Archivist archivist = this.archivistFactory.getArchivist(sourceArchive, cl);
        archivist.setAnnotationProcessingRequested(true);
        archivist.setXMLValidation(false);
        archivist.setRuntimeXMLValidation(false);
        archivist.setDefaultBundleDescriptor((RootDeploymentDescriptor)RootDeploymentDescriptor.class.cast(defaultValue));
        if (dc.getModuleMetaData(Application.class) == null) {
            String deploymentPlan = props.getProperty("deploymentplan");
            this.handleDeploymentPlan(deploymentPlan, archivist, sourceArchive);
        }
        try {
            application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
        }
        catch (SAXParseException e) {
            throw new IOException(e);
        }
        if (this.deploymentVisitor != null) {
            this.deploymentVisitor.accept(application);
        }
        return application;
    }

    protected void handleDeploymentPlan(String deploymentPlan, Archivist archivist, ReadableArchive sourceArchive) throws IOException {
        if (deploymentPlan != null) {
            DeploymentPlanArchive dpa = new DeploymentPlanArchive();
            dpa.open(new File(deploymentPlan).toURI());
            WritableArchive targetArchive = this.archiveFactory.createArchive(sourceArchive.getURI());
            archivist.copyInto((ReadableArchive)dpa, targetArchive, false);
        }
    }
}

