/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet.handlers;

import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import java.io.IOException;
import java.io.PrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectorCometHandler
implements CometHandler<PrintWriter> {
    protected PrintWriter printWriter;
    private String startingMessage = "";
    private String endingMessage = "";
    private boolean useStreaming = true;

    public ReflectorCometHandler() {
    }

    public ReflectorCometHandler(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    public ReflectorCometHandler(boolean useStreaming, String startingMessage, String endingMessage) {
        this.useStreaming = useStreaming;
        this.startingMessage = startingMessage;
        this.endingMessage = endingMessage;
    }

    @Override
    public void attach(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Override
    public synchronized void onEvent(CometEvent event) throws IOException {
        try {
            if (event.getType() != 4) {
                this.printWriter.println(event.attachment());
                this.printWriter.flush();
                if (!this.useStreaming) {
                    event.getCometContext().resumeCometHandler(this);
                }
            }
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage());
        }
    }

    @Override
    public void onInitialize(CometEvent event) throws IOException {
        this.printWriter.println(this.startingMessage);
        this.printWriter.flush();
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.onInterrupt(event);
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
        this.printWriter.println(this.endingMessage);
        this.printWriter.flush();
        this.printWriter.close();
    }
}

