/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class InterfacePolicy
implements Serializable {
    protected Vector parentInterfaces;
    protected Vector parentInterfaceNames;
    protected Vector parentDescriptors;
    protected Vector childDescriptors = NonSynchronizedVector.newInstance();
    protected ClassDescriptor descriptor;
    protected Class implementorDescriptor;
    protected String implementorDescriptorClassName;

    public InterfacePolicy() {
        this.parentInterfaces = NonSynchronizedVector.newInstance(2);
        this.parentInterfaceNames = NonSynchronizedVector.newInstance(2);
        this.parentDescriptors = NonSynchronizedVector.newInstance(2);
    }

    public InterfacePolicy(ClassDescriptor descriptor) {
        this();
        this.descriptor = descriptor;
    }

    public void addChildDescriptor(ClassDescriptor childDescriptor) {
        this.getChildDescriptors().addElement(childDescriptor);
    }

    public void addParentDescriptor(ClassDescriptor parentDescriptor) {
        this.getParentDescriptors().addElement(parentDescriptor);
    }

    public void addParentInterface(Class parentInterface) {
        this.getParentInterfaces().addElement(parentInterface);
    }

    public void addParentInterfaceName(String parentInterfaceName) {
        this.getParentInterfaceNames().addElement(parentInterfaceName);
    }

    public Vector getChildDescriptors() {
        return this.childDescriptors;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getImplementorDescriptor() {
        return this.implementorDescriptor;
    }

    public String getImplementorDescriptorClassName() {
        if (this.implementorDescriptorClassName == null && this.implementorDescriptor != null) {
            this.implementorDescriptorClassName = this.implementorDescriptor.getName();
        }
        return this.implementorDescriptorClassName;
    }

    public Vector getParentDescriptors() {
        return this.parentDescriptors;
    }

    public Vector getParentInterfaces() {
        return this.parentInterfaces;
    }

    public Vector getParentInterfaceNames() {
        if (this.parentInterfaceNames.isEmpty() && !this.parentInterfaces.isEmpty()) {
            for (int i = 0; i < this.parentInterfaces.size(); ++i) {
                this.parentInterfaceNames.addElement(((Class)this.parentInterfaces.elementAt(i)).getName());
            }
        }
        return this.parentInterfaceNames;
    }

    public void initialize(AbstractSession session) {
    }

    public boolean isInterfaceChildDescriptor() {
        return this.parentInterfaces != null && !this.parentInterfaces.isEmpty() || this.parentInterfaceNames != null && !this.parentInterfaceNames.isEmpty();
    }

    public Object selectAllObjectsUsingMultipleTableSubclassRead(ReadAllQuery query) throws DatabaseException {
        ContainerPolicy containerPolicy = query.getContainerPolicy();
        Object objects = containerPolicy.containerInstance(1);
        Enumeration childDescriptors = this.getChildDescriptors().elements();
        while (childDescriptors.hasMoreElements()) {
            ReadAllQuery concreteQuery = (ReadAllQuery)query.deepClone();
            ClassDescriptor descriptor = (ClassDescriptor)childDescriptors.nextElement();
            Class javaClass = descriptor.getJavaClass();
            concreteQuery.setReferenceClass(javaClass);
            concreteQuery.setDescriptor(descriptor);
            objects = containerPolicy.concatenateContainers(objects, query.getSession().executeQuery(concreteQuery));
        }
        return objects;
    }

    public Object selectOneObjectUsingMultipleTableSubclassRead(ReadObjectQuery query) throws DatabaseException, QueryException {
        Object object = null;
        Enumeration childDescriptors = this.getChildDescriptors().elements();
        while (childDescriptors.hasMoreElements() && object == null) {
            ReadObjectQuery concreteQuery = (ReadObjectQuery)query.clone();
            ClassDescriptor descriptor = (ClassDescriptor)childDescriptors.nextElement();
            Class javaClass = descriptor.getJavaClass();
            concreteQuery.setReferenceClass(javaClass);
            concreteQuery.setDescriptor(descriptor);
            object = query.getSession().executeQuery((DatabaseQuery)concreteQuery, concreteQuery.getTranslationRow());
        }
        return object;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setImplementorDescriptor(Class implementorDescriptor) {
        this.implementorDescriptor = implementorDescriptor;
    }

    public void setImplementorDescriptorClassName(String implementorDescriptorClassName) {
        this.implementorDescriptorClassName = implementorDescriptorClassName;
    }

    public void setParentInterfaces(Vector parentInterfaces) {
        this.parentInterfaces = parentInterfaces;
    }

    public void setParentInterfaceNames(Vector parentInterfaceNames) {
        this.parentInterfaceNames = parentInterfaceNames;
    }

    public boolean usesImplementorDescriptor() {
        return this.implementorDescriptor != null;
    }
}

