/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.persistence.internal.helper.TimeZoneHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatThreadLocal
extends ThreadLocal<DateFormat> {
    protected String formatStr;
    protected TimeZoneHolder timeZoneHolder;

    public DateFormatThreadLocal(String formatStr, TimeZoneHolder timeZoneHolder) {
        this.formatStr = formatStr;
        this.timeZoneHolder = timeZoneHolder;
    }

    @Override
    public DateFormat get() {
        TimeZone tz;
        DateFormat simpleDateFormat = (DateFormat)super.get();
        if (this.timeZoneHolder != null && (tz = this.timeZoneHolder.getTimeZone()) != null && !simpleDateFormat.getTimeZone().equals(tz)) {
            simpleDateFormat.setTimeZone(tz);
        }
        return simpleDateFormat;
    }

    @Override
    protected DateFormat initialValue() {
        SimpleDateFormat format = new SimpleDateFormat(this.formatStr);
        return format;
    }
}

