/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLCompositeCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private XMLCompositeCollectionMapping xmlCompositeCollectionMapping;

    public XMLCompositeCollectionMappingNodeValue(XMLCompositeCollectionMapping xmlCompositeCollectionMapping) {
        this.xmlCompositeCollectionMapping = xmlCompositeCollectionMapping;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlCompositeCollectionMapping.isReadOnly()) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object collection = this.xmlCompositeCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (cp.hasNext(iterator)) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            return false;
        }
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
            if (xmlDescriptor == null) {
                xmlDescriptor = this.findReferenceDescriptor(unmarshalRecord, atts, this.xmlCompositeCollectionMapping);
            }
            if (this.xmlCompositeCollectionMapping.getNullPolicy().valueIsNull(atts)) {
                this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
            } else {
                XMLField xmlFld = (XMLField)this.xmlCompositeCollectionMapping.getField();
                if (xmlFld.hasLastXPathFragment()) {
                    unmarshalRecord.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
                }
                this.processChild(xPathFragment, unmarshalRecord, atts, xmlDescriptor);
            }
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        this.endElement(xPathFragment, unmarshalRecord, collection);
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        if (null == unmarshalRecord.getChildRecord()) {
            return;
        }
        Object objectValue = unmarshalRecord.getChildRecord().getCurrentObject();
        if (this.xmlCompositeCollectionMapping.hasConverter()) {
            Converter converter = this.xmlCompositeCollectionMapping.getConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertObjectValueToDataValue(objectValue, unmarshalRecord.getSession());
        }
        unmarshalRecord.addAttributeValue(this, objectValue, collection);
        unmarshalRecord.setChildRecord(null);
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlCompositeCollectionMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    protected void addTypeAttributeIfNeeded(XMLDescriptor descriptor, DatabaseMapping mapping, MarshalRecord marshalRecord) {
        XMLSchemaReference xmlRef = descriptor.getSchemaReference();
        if (this.xmlCompositeCollectionMapping.shouldAddXsiType(marshalRecord, descriptor) && xmlRef != null) {
            this.addTypeAttribute(descriptor, marshalRecord, xmlRef.getSchemaContext());
        }
    }

    public void marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (xPathFragment.hasLeafElementType()) {
            marshalRecord.setLeafElementType(xPathFragment.getLeafElementType());
        }
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        if (this.xmlCompositeCollectionMapping.hasConverter()) {
            Converter converter = this.xmlCompositeCollectionMapping.getConverter();
            value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(value, session, marshaller) : converter.convertObjectValueToDataValue(value, session);
        }
        if (null == value) {
            this.xmlCompositeCollectionMapping.getNullPolicy().compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
            return;
        }
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(value);
        TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(value);
        }
        this.getXPathNode().startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, objectBuilder, value);
        if (this.xmlCompositeCollectionMapping.getReferenceDescriptor() == null && descriptor.getSchemaReference() != null) {
            this.addTypeAttributeIfNeeded(descriptor, this.xmlCompositeCollectionMapping, marshalRecord);
        }
        List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session);
        this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
        objectBuilder.buildRow((AbstractRecord)marshalRecord, value, session, marshaller);
        marshalRecord.endElement(xPathFragment, namespaceResolver);
        objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(value);
        }
    }

    public XMLCompositeCollectionMapping getMapping() {
        return this.xmlCompositeCollectionMapping;
    }
}

