/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.rails;

import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.scripting.rails.Messages;
import org.glassfish.scripting.rails.RailsApplication;
import org.glassfish.scripting.rails.RailsContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class RailsDeployer
implements Deployer<RailsContainer, RailsApplication> {
    @Inject
    ServerEnvironment env;
    @Inject
    RequestDispatcher dispatcher;
    private JRubyEnvironment jrubyEnv;
    private Logger logger;

    public boolean prepare(DeploymentContext context) {
        return true;
    }

    public <T> T loadMetaData(Class<T> type, DeploymentContext context) {
        return null;
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, null);
    }

    public RailsApplication load(RailsContainer container, DeploymentContext context) {
        String contextRoot = this.getContextRoot(context);
        String railsRoot = context.getSource().getURI().getSchemeSpecificPart();
        this.logger = context.getLogger();
        this.jrubyEnv = new JRubyEnvironment(this.env.getStartupContext(), context.getProps());
        RailsApplication railsApplication = new RailsApplication(this.jrubyEnv, railsRoot, context.getLogger(), contextRoot);
        context.getLogger().info(Messages.format("railsdeployer.loading.info", context.getCommandParameters().getProperty("name"), contextRoot));
        try {
            this.dispatcher.registerEndpoint(contextRoot, railsApplication.getAdapter(), (ApplicationContainer)railsApplication);
        }
        catch (EndpointRegistrationException e) {
            context.getLogger().log(Level.SEVERE, Messages.format("railsdeployer.adapter.registry.err", context.getCommandParameters().getProperty("name")), e);
        }
        return railsApplication;
    }

    public void unload(RailsApplication container, DeploymentContext context) {
        try {
            this.dispatcher.unregisterEndpoint(container.getContextRoot());
        }
        catch (EndpointRegistrationException e) {
            context.getLogger().log(Level.SEVERE, Messages.format("railsdeployer.unload.err", container.getContextRoot()), e);
        }
    }

    public void clean(DeploymentContext context) {
    }

    private String getContextRoot(DeploymentContext context) {
        String contextRoot = context.getCommandParameters().getProperty("contextroot");
        if (contextRoot == null) {
            contextRoot = (String)this.env.getStartupContext().getArguments().get("--contextroot");
        }
        if (contextRoot == null || contextRoot.length() == 0) {
            contextRoot = "/" + context.getCommandParameters().getProperty("name");
        }
        return contextRoot;
    }

    public final class JRubyEnvironment {
        final String jrubyHome = System.getProperty("jruby.home");
        private final String jrubyMinRuntime = System.getProperty("jruby.runtime.min");
        private final String jrubyMaxRuntime = System.getProperty("jruby.runtime.max");
        final int numberOfRuntime;
        final String jrubyLib;
        final int minRuntime;
        final int maxRuntime;
        final File rootDir;
        private static final String JRUBY_RUNTIME = "jruby-runtime";
        private static final String JRUBY_RUNTIME_MIN = "jruby-runtime-min";
        private static final String JRUBY_RUNTIME_MAX = "jruby-runtime-max";
        private static final String RAILS_ENV = "rails-env";
        private final String jrubyRuntime = System.getProperty("jruby.runtime");
        final String railsEnv;

        public JRubyEnvironment(StartupContext startupContext, Properties props) {
            int numMaxRt;
            if (this.jrubyHome == null) {
                RailsDeployer.this.logger.severe(Messages.format("railsapplication.jrubyhome.null", new Object[0]));
                throw new IllegalArgumentException(Messages.format("railsapplication.jrubyhome.null", new Object[0]));
            }
            if (System.getenv("RAILS_ENV") != null) {
                this.railsEnv = System.getenv("RAILS_ENV");
                props.put(RAILS_ENV, this.railsEnv);
            } else {
                this.railsEnv = props.getProperty(RAILS_ENV) == null ? "development" : props.getProperty(RAILS_ENV);
            }
            this.rootDir = startupContext.getRootDirectory();
            int numRt = props.getProperty(JRUBY_RUNTIME) == null ? 1 : Integer.valueOf(props.getProperty(JRUBY_RUNTIME));
            int numMinRt = props.getProperty(JRUBY_RUNTIME_MIN) == null ? -1 : Integer.valueOf(props.getProperty(JRUBY_RUNTIME_MIN));
            int n = numMaxRt = props.getProperty(JRUBY_RUNTIME_MAX) == null ? -1 : Integer.valueOf(props.getProperty(JRUBY_RUNTIME_MAX));
            if (this.jrubyRuntime != null) {
                try {
                    numRt = Integer.parseInt(this.jrubyRuntime);
                    props.setProperty(JRUBY_RUNTIME, String.valueOf(numRt));
                }
                catch (NumberFormatException ex) {
                    RailsDeployer.this.logger.log(Level.WARNING, Messages.format("railsapplication.runtimes.invalid", this.jrubyRuntime), ex);
                }
            }
            if (this.jrubyMinRuntime != null) {
                try {
                    numMinRt = Integer.parseInt(this.jrubyMinRuntime);
                    props.setProperty(JRUBY_RUNTIME_MIN, String.valueOf(numMinRt));
                }
                catch (NumberFormatException ex) {
                    RailsDeployer.this.logger.log(Level.WARNING, Messages.format("railsapplication.runtimes.min.invalid", this.jrubyMinRuntime), ex);
                }
            }
            if (this.jrubyMaxRuntime != null) {
                try {
                    numMaxRt = Integer.parseInt(this.jrubyMaxRuntime);
                    props.setProperty(JRUBY_RUNTIME_MAX, String.valueOf(numMaxRt));
                }
                catch (NumberFormatException ex) {
                    RailsDeployer.this.logger.log(Level.WARNING, Messages.format("railsapplication.runtimes.max.invalid", this.jrubyMaxRuntime), ex);
                }
            }
            this.minRuntime = numMinRt;
            this.maxRuntime = numMaxRt;
            if (startupContext.getArguments().get("--runtimes") != null) {
                String nrt = (String)startupContext.getArguments().get("--runtimes");
                try {
                    numRt = Integer.parseInt(nrt);
                    props.put(JRUBY_RUNTIME, (Object)numRt);
                }
                catch (NumberFormatException ex) {
                    RailsDeployer.this.logger.log(Level.WARNING, Messages.format("railsapplication.runtimes.invalid", nrt));
                }
            }
            this.numberOfRuntime = numRt;
            this.jrubyLib = this.jrubyHome + "/lib";
        }
    }
}

