/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.module.ConnectorContainer;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.javaee.services.ResourceManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConnectorDeployer
extends JavaEEDeployer<ConnectorContainer, ConnectorApplication>
implements PostConstruct {
    @Inject
    private ConnectorRuntime runtime;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ResourceManager resourceManager;
    private static Logger _logger = LogDomains.getLogger(ConnectorDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    private ConnectorClassFinder ccf = null;

    public <T> T loadMetaData(Class<T> type, DeploymentContext context) {
        return null;
    }

    public ConnectorApplication load(ConnectorContainer container, DeploymentContext context) {
        File sourceDir = context.getSourceDir();
        String sourcePath = sourceDir.getAbsolutePath();
        String moduleName = sourceDir.getName();
        if (!ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            try {
                this.ccf = (ConnectorClassFinder)context.getClassLoader();
                this.runtime.createActiveResourceAdapter(sourcePath, moduleName, (ClassLoader)this.ccf);
                this.clh.getConnectorClassLoader(null).addDelegate((DelegatingClassLoader.ClassFinder)this.ccf);
            }
            catch (ConnectorRuntimeException cre) {
                _logger.log(Level.WARNING, " unable to load the resource-adapter [ " + moduleName + " ]", cre);
            }
        }
        return new ConnectorApplication(moduleName, this.resourceManager, (ClassLoader)this.ccf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(ConnectorApplication appContainer, DeploymentContext context) {
        File sourceDir = context.getSourceDir();
        String moduleName = sourceDir.getName();
        try {
            this.runtime.destroyActiveResourceAdapter(moduleName, true);
        }
        catch (ConnectorRuntimeException e) {
            _logger.log(Level.WARNING, " unable to unload the resource-adapter [ " + moduleName + " ]", e);
        }
        finally {
            this.clh.getConnectorClassLoader(null).removeDelegate((DelegatingClassLoader.ClassFinder)this.ccf);
        }
    }

    public void clean(DeploymentContext context) {
    }

    protected RootDeploymentDescriptor getDefaultBundleDescriptor() {
        return null;
    }

    protected String getModuleType() {
        return "connectors";
    }

    public void postConstruct() {
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }
}

