/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.config.Property;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@I18n(value="add.resources")
public class JDBCConnectionPoolManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCConnectionPoolManager.class);
    private String datasourceclassname = null;
    private String restype = null;
    private String steadypoolsize = "8";
    private String maxpoolsize = "32";
    private String maxwait = "60000";
    private String poolresize = "2";
    private String idletimeout = "300";
    private String isolationlevel = null;
    private String isisolationguaranteed = Boolean.TRUE.toString();
    private String isconnectvalidatereq = Boolean.FALSE.toString();
    private String validationmethod = "auto-commit";
    private String validationtable = null;
    private String failconnection = Boolean.FALSE.toString();
    private String allownoncomponentcallers = Boolean.FALSE.toString();
    private String nontransactionalconnections = Boolean.FALSE.toString();
    private String validateAtmostOncePeriod = "0";
    private String connectionLeakTimeout = "0";
    private String connectionLeakReclaim = Boolean.FALSE.toString();
    private String connectionCreationRetryAttempts = "0";
    private String connectionCreationRetryInterval = "10";
    private String statementTimeout = "-1";
    private String lazyConnectionEnlistment = Boolean.FALSE.toString();
    private String lazyConnectionAssociation = Boolean.FALSE.toString();
    private String associateWithThread = Boolean.FALSE.toString();
    private String matchConnections = Boolean.FALSE.toString();
    private String maxConnectionUsageCount = "0";
    private String wrapJDBCObjects = Boolean.FALSE.toString();
    private String description = null;
    private String jdbcconnectionpoolid = null;

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        this.setParams(attrList);
        if (this.jdbcconnectionpoolid == null) {
            String msg = localStrings.getLocalString("add.resources.noJdbcConnectionPoolId", "No pool name defined for JDBC Connection pool.");
            return new ResourceStatus(1, msg);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcConnectionPool) || !((JdbcConnectionPool)resource).getName().equals(this.jdbcconnectionpoolid)) continue;
            String msg = localStrings.getLocalString("create.jdbc.connection.pool.duplicate", "A JDBC connection pool named {0} already exists.", new Object[]{this.jdbcconnectionpoolid});
            return new ResourceStatus(1, msg, true);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcConnectionPool newResource = (JdbcConnectionPool)ConfigSupport.createChildOf((Object)param, JdbcConnectionPool.class);
                    newResource.setWrapJdbcObjects(JDBCConnectionPoolManager.this.wrapJDBCObjects);
                    if (JDBCConnectionPoolManager.this.validationtable != null) {
                        newResource.setValidationTableName(JDBCConnectionPoolManager.this.validationtable);
                    }
                    newResource.setValidateAtmostOncePeriodInSeconds(JDBCConnectionPoolManager.this.validateAtmostOncePeriod);
                    if (JDBCConnectionPoolManager.this.isolationlevel != null) {
                        newResource.setTransactionIsolationLevel(JDBCConnectionPoolManager.this.isolationlevel);
                    }
                    newResource.setSteadyPoolSize(JDBCConnectionPoolManager.this.steadypoolsize);
                    newResource.setStatementTimeoutInSeconds(JDBCConnectionPoolManager.this.statementTimeout);
                    if (JDBCConnectionPoolManager.this.restype != null) {
                        newResource.setResType(JDBCConnectionPoolManager.this.restype);
                    }
                    newResource.setPoolResizeQuantity(JDBCConnectionPoolManager.this.poolresize);
                    newResource.setNonTransactionalConnections(JDBCConnectionPoolManager.this.nontransactionalconnections);
                    newResource.setMaxWaitTimeInMillis(JDBCConnectionPoolManager.this.maxwait);
                    newResource.setMaxPoolSize(JDBCConnectionPoolManager.this.maxpoolsize);
                    newResource.setMaxConnectionUsageCount(JDBCConnectionPoolManager.this.maxConnectionUsageCount);
                    newResource.setMatchConnections(JDBCConnectionPoolManager.this.matchConnections);
                    newResource.setLazyConnectionEnlistment(JDBCConnectionPoolManager.this.lazyConnectionEnlistment);
                    newResource.setLazyConnectionAssociation(JDBCConnectionPoolManager.this.lazyConnectionAssociation);
                    newResource.setIsIsolationLevelGuaranteed(JDBCConnectionPoolManager.this.isisolationguaranteed);
                    newResource.setIsConnectionValidationRequired(JDBCConnectionPoolManager.this.isconnectvalidatereq);
                    newResource.setIdleTimeoutInSeconds(JDBCConnectionPoolManager.this.idletimeout);
                    newResource.setFailAllConnections(JDBCConnectionPoolManager.this.failconnection);
                    if (JDBCConnectionPoolManager.this.datasourceclassname != null) {
                        newResource.setDatasourceClassname(JDBCConnectionPoolManager.this.datasourceclassname);
                    }
                    newResource.setConnectionValidationMethod(JDBCConnectionPoolManager.this.validationmethod);
                    newResource.setConnectionLeakTimeoutInSeconds(JDBCConnectionPoolManager.this.connectionLeakTimeout);
                    newResource.setConnectionLeakReclaim(JDBCConnectionPoolManager.this.connectionLeakReclaim);
                    newResource.setConnectionCreationRetryIntervalInSeconds(JDBCConnectionPoolManager.this.connectionCreationRetryInterval);
                    newResource.setConnectionCreationRetryAttempts(JDBCConnectionPoolManager.this.connectionCreationRetryAttempts);
                    newResource.setAssociateWithThread(JDBCConnectionPoolManager.this.associateWithThread);
                    newResource.setAllowNonComponentCallers(JDBCConnectionPoolManager.this.allownoncomponentcallers);
                    if (JDBCConnectionPoolManager.this.description != null) {
                        newResource.setDescription(JDBCConnectionPoolManager.this.description);
                    }
                    newResource.setName(JDBCConnectionPoolManager.this.jdbcconnectionpoolid);
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)ConfigSupport.createChildOf((Object)newResource, Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} create failed: {1}", new Object[]{this.jdbcconnectionpoolid, tfe.getMessage()});
            return new ResourceStatus(1, msg);
        }
        String msg = localStrings.getLocalString("create.jdbc.connection.pool.success", "JDBC connection pool {0} created successfully", new Object[]{this.jdbcconnectionpoolid});
        return new ResourceStatus(0, msg);
    }

    public void setParams(HashMap attrList) {
        this.datasourceclassname = (String)attrList.get("datasource-classname");
        this.restype = (String)attrList.get("res-type");
        this.steadypoolsize = (String)attrList.get("steady-pool-size");
        this.maxpoolsize = (String)attrList.get("max-pool-size");
        this.maxwait = (String)attrList.get("max-wait-time-in-millis");
        this.poolresize = (String)attrList.get("pool-resize-quantity");
        this.idletimeout = (String)attrList.get("idle-timeout-in-seconds");
        this.isolationlevel = (String)attrList.get("transaction-isolation-level");
        this.isisolationguaranteed = (String)attrList.get("is-isolation-level-guaranteed");
        this.isconnectvalidatereq = (String)attrList.get("is-connection-validation-required");
        this.validationmethod = (String)attrList.get("connection-validation-method");
        this.validationtable = (String)attrList.get("validation-table-name");
        this.failconnection = (String)attrList.get("fail-all-connections");
        this.allownoncomponentcallers = (String)attrList.get("allow-non-component-callers");
        this.nontransactionalconnections = (String)attrList.get("non-transactional-connections");
        this.validateAtmostOncePeriod = (String)attrList.get("validate-atmost-once-period-in-seconds");
        this.connectionLeakTimeout = (String)attrList.get("connection-leak-timeout-in-seconds");
        this.connectionLeakReclaim = (String)attrList.get("connection-leak-reclaim");
        this.connectionCreationRetryAttempts = (String)attrList.get("connection-creation-retry-attempts");
        this.connectionCreationRetryInterval = (String)attrList.get("connection-creation-retry-interval-in-seconds");
        this.statementTimeout = (String)attrList.get("statement-timeout");
        this.lazyConnectionEnlistment = (String)attrList.get("lazy-connection-enlistment");
        this.lazyConnectionAssociation = (String)attrList.get("lazy-connection-association");
        this.associateWithThread = (String)attrList.get("associate-with-thread");
        this.matchConnections = (String)attrList.get("match-connections");
        this.maxConnectionUsageCount = (String)attrList.get("max-connection-usage-count");
        this.wrapJDBCObjects = (String)attrList.get("wrap-jdbc-objects");
        this.description = (String)attrList.get(DESCRIPTION);
        this.jdbcconnectionpoolid = (String)attrList.get("name");
    }

    public ResourceStatus delete(Server[] servers, Resources resources, final JdbcConnectionPool[] connPools, String cascade, final String jdbcconnectionpoolid) throws Exception {
        if (jdbcconnectionpoolid == null) {
            String msg = localStrings.getLocalString("jdbcConnPool.resource.noJndiName", "No id defined for JDBC Connection pool.");
            ResourceStatus status = new ResourceStatus(1, msg);
            return status;
        }
        if (!this.isResourceExists(resources, jdbcconnectionpoolid)) {
            String msg = localStrings.getLocalString("delete.jdbc.connection.pool.notfound", "A JDBC connection pool named {0} does not exist.", new Object[]{jdbcconnectionpoolid});
            ResourceStatus status = new ResourceStatus(1, msg);
            return status;
        }
        try {
            Object obj = this.deleteAssociatedResources(servers, resources, Boolean.parseBoolean(cascade), jdbcconnectionpoolid);
            if (obj == Integer.valueOf(1)) {
                String msg = localStrings.getLocalString("delete.jdbc.connection.pool.pool_in_use", "JDBC Connection pool {0} delete failed ", new Object[]{jdbcconnectionpoolid});
                ResourceStatus status = new ResourceStatus(1, msg);
                return status;
            }
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (JdbcConnectionPool cp : connPools) {
                        if (!cp.getName().equals(jdbcconnectionpoolid)) continue;
                        return param.getResources().remove(cp);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("delete.jdbc.connection.pool.notfound", "A JDBC connection pool named {0} does not exist.", new Object[]{jdbcconnectionpoolid});
                ResourceStatus status = new ResourceStatus(1, msg);
                return status;
            }
        }
        catch (TransactionFailure tfe) {
            String msg = tfe.getMessage() != null ? tfe.getMessage() : localStrings.getLocalString("jdbcConnPool.resource.deletionFailed", "JDBC Connection pool {0} delete failed ", new Object[]{jdbcconnectionpoolid});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("jdbcConnPool.resource.deleteSuccess", "JDBC Connection pool {0} deleted successfully", new Object[]{jdbcconnectionpoolid});
        ResourceStatus status = new ResourceStatus(0, msg);
        return status;
    }

    public ArrayList list(JdbcConnectionPool[] connPools) {
        ArrayList<String> list = new ArrayList<String>();
        for (JdbcConnectionPool cp : connPools) {
            list.add(cp.getName());
        }
        return list;
    }

    private boolean isResourceExists(Resources resources, String jdbcconnectionpoolid) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcConnectionPool) || !((JdbcConnectionPool)resource).getName().equals(jdbcconnectionpoolid)) continue;
            return true;
        }
        return false;
    }

    private Object deleteAssociatedResources(final Server[] servers, Resources resources, final boolean cascade, final String connPoolId) throws TransactionFailure {
        return ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

            public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                Resource res = null;
                for (Resource resource : param.getResources()) {
                    if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getPoolName().equals(connPoolId)) continue;
                    if (cascade) {
                        JDBCConnectionPoolManager.this.deleteResourceRefs(servers, ((JdbcResource)resource).getJndiName());
                        res = resource;
                        break;
                    }
                    return 1;
                }
                if (res != null) {
                    param.getResources().remove(res);
                }
                return null;
            }
        }, (ConfigBeanProxy)resources);
    }

    private void deleteResourceRefs(Server[] servers, String refName) throws TransactionFailure {
        for (Server server : servers) {
            server.deleteResourceRef(refName);
        }
    }
}

