/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
@Async
public class AutoDeployService
implements Startup,
PostConstruct,
PreDestroy,
ConfigListener {
    @Inject
    DasConfig activeDasConfig;
    @Inject
    Habitat habitat;
    private AutoDeployer autoDeployer;
    private Timer autoDeployerTimer;
    private TimerTask autoDeployerTimerTask;
    private String target;
    private static final String DAS_TARGET = "server";
    private static final List<String> configPropertyNames = Arrays.asList("autodeploy-enabled", "autodeploy-polling-interval-in-seconds", "autodeploy-verifier-enabled", "autodeploy-jsp-precompilation-enabled");
    private Logger logger;
    private static final String DEFAULT_POLLING_INTERVAL_IN_SECONDS = "2";
    private static final String DEFAULT_AUTO_DEPLOY_ENABLED = "true";

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        this.logger = LogDomains.getLogger(AutoDeployService.class, (String)"org.glassfish.deployment.autodeploy");
        String directory = this.activeDasConfig.getAutodeployDir();
        this.target = this.getTarget();
        try {
            this.autoDeployer = new AutoDeployer(this.target, directory, this.getDefaultVirtualServer(), Boolean.parseBoolean(this.activeDasConfig.getAutodeployJspPrecompilationEnabled()), Boolean.parseBoolean(this.activeDasConfig.getAutodeployVerifierEnabled()), true, true, true, this.habitat);
            this.autoDeployerTimer = new Timer("AutoDeployer", true);
            boolean isEnabled = this.isAutoDeployEnabled();
            int pollingIntervalInSeconds = Integer.valueOf(DEFAULT_POLLING_INTERVAL_IN_SECONDS);
            try {
                pollingIntervalInSeconds = this.getPollingIntervalInSeconds();
            }
            catch (NumberFormatException ex) {
                this.logger.log(Level.WARNING, "enterprise.deployment.autodeploy.error_parsing_polling_interval", new Object[]{this.activeDasConfig.getAutodeployPollingIntervalInSeconds(), ex.getClass().getName(), ex.getLocalizedMessage()});
            }
            if (isEnabled) {
                this.startAutoDeployer(pollingIntervalInSeconds);
            }
        }
        catch (AutoDeploymentException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)((Object)e));
        }
    }

    public void preDestroy() {
        this.stopAutoDeployer();
    }

    static String getValue(String value, String defaultValue) {
        return value == null || value.equals("") ? defaultValue : value;
    }

    private void logConfig(String title, boolean isEnabled, int pollingIntervalInSeconds, String directory) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("[AutoDeploy] " + title + ", enabled=" + isEnabled + ", polling interval(seconds)=" + pollingIntervalInSeconds + ", directory=" + directory);
        }
    }

    private String getTarget() {
        return DAS_TARGET;
    }

    private String getDefaultVirtualServer() {
        return null;
    }

    private boolean isAutoDeployEnabled() {
        return Boolean.parseBoolean(AutoDeployService.getValue(this.activeDasConfig.getAutodeployEnabled(), DEFAULT_AUTO_DEPLOY_ENABLED));
    }

    private int getPollingIntervalInSeconds() throws NumberFormatException {
        return Integer.parseInt(AutoDeployService.getValue(this.activeDasConfig.getAutodeployPollingIntervalInSeconds(), DEFAULT_POLLING_INTERVAL_IN_SECONDS));
    }

    private void startAutoDeployer(int pollingIntervalInSeconds) {
        long pollingInterval = pollingIntervalInSeconds * 1000;
        this.autoDeployerTimerTask = new TimerTask(){

            public void run() {
                try {
                    AutoDeployService.this.autoDeployer.run();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.autoDeployerTimer.schedule(this.autoDeployerTimerTask, pollingInterval, pollingInterval);
        this.logConfig("Started", this.isAutoDeployEnabled(), pollingIntervalInSeconds, this.activeDasConfig.getAutodeployDir());
    }

    private void stopAutoDeployer() {
        this.logger.fine("[AutoDeploy] Stopping");
        this.autoDeployer.cancel(true);
        this.autoDeployerTimerTask.cancel();
    }

    private void rescheduleAutoDeployer(int pollingIntervalInSeconds) {
        this.logger.fine("[AutoDeploy] Restarting...");
        this.stopAutoDeployer();
        try {
            this.autoDeployer.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startAutoDeployer(pollingIntervalInSeconds);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList unprocessedEvents = new ArrayList();
        Boolean newEnabled = null;
        Integer newPollingIntervalInSeconds = null;
        for (PropertyChangeEvent event : events) {
            if (!(event.getSource() instanceof DasConfig)) continue;
            String propName = event.getPropertyName();
            if (configPropertyNames.contains(propName) && event.getOldValue().equals(event.getNewValue())) {
                this.logger.fine("[AutoDeploy] Ignoring reconfig of " + propName + " from " + event.getOldValue() + " to " + event.getNewValue());
                continue;
            }
            if (propName.equals("autodeploy-enabled")) {
                newEnabled = Boolean.valueOf((String)event.getNewValue());
                this.logger.fine("[AutoDeploy] Reconfig - enabled changed to " + newEnabled);
                continue;
            }
            if (propName.equals("autodeploy-polling-interval-in-seconds")) {
                try {
                    newPollingIntervalInSeconds = new Integer((String)event.getNewValue());
                    this.logger.fine("[AutoDeploy] Reconfig - polling interval (seconds) changed from " + (String)event.getOldValue() + " to " + newPollingIntervalInSeconds);
                }
                catch (NumberFormatException ex) {
                    this.logger.log(Level.WARNING, "enterprise.deployment.autodeploy.error_processing_config_change", new Object[]{propName, event.getOldValue(), event.getNewValue(), ex.getClass().getName(), ex.getLocalizedMessage()});
                }
                continue;
            }
            if (propName.equals("autodeploy-dir")) {
                String newDir = (String)event.getNewValue();
                try {
                    this.autoDeployer.setDirectory(newDir);
                    this.logger.fine("[AutoDeploy] Reconfig - directory changed from " + (String)event.getOldValue() + " to " + newDir);
                }
                catch (AutoDeploymentException ex) {
                    this.logger.log(Level.WARNING, "enterprise.deployment.autodeploy.error_processing_config_change", new Object[]{propName, event.getOldValue(), event.getNewValue(), ((Object)((Object)ex)).getClass().getName(), ex.getCause().getLocalizedMessage()});
                }
                continue;
            }
            if (propName.equals("autodeploy-verifier-enabled")) {
                boolean newVerifierEnabled = Boolean.parseBoolean((String)event.getOldValue());
                this.autoDeployer.setVerifierEnabled(newVerifierEnabled);
                this.logger.fine("[AutoDeploy] Reconfig - verifierEnabled changed from " + Boolean.parseBoolean((String)event.getOldValue()) + " to " + newVerifierEnabled);
                continue;
            }
            if (!propName.equals("autodeploy-jsp-precompilation-enabled")) continue;
            boolean newJspPrecompiled = Boolean.parseBoolean((String)event.getNewValue());
            this.autoDeployer.setJspPrecompilationEnabled(newJspPrecompiled);
            this.logger.fine("[AutoDeploy] Reconfig - jspPrecompilationEnabled changed from " + Boolean.parseBoolean((String)event.getOldValue()) + " to " + newJspPrecompiled);
        }
        if (newEnabled != null) {
            if (newEnabled.booleanValue()) {
                this.startAutoDeployer(newPollingIntervalInSeconds == null ? this.getPollingIntervalInSeconds() : newPollingIntervalInSeconds.intValue());
            } else {
                this.stopAutoDeployer();
            }
        } else if (newPollingIntervalInSeconds != null && this.isAutoDeployEnabled()) {
            this.rescheduleAutoDeployer(newPollingIntervalInSeconds);
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }
}

