/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainEquinox;
import com.sun.enterprise.glassfish.bootstrap.ASMainFelix;
import com.sun.enterprise.glassfish.bootstrap.ASMainKnopflerFish;
import com.sun.enterprise.glassfish.bootstrap.ASMainStatic;
import java.util.logging.Logger;

public class ASMain {
    static final Logger logger = Logger.getAnonymousLogger();
    private static final String PLATFORM_PROPERTY_KEY = "GlassFish_Platform";

    public static void main(String[] args) {
        Platform platform = Platform.Felix;
        String temp = System.getProperty(PLATFORM_PROPERTY_KEY);
        if (temp == null || temp.trim().length() <= 0) {
            temp = System.getenv(PLATFORM_PROPERTY_KEY);
        }
        if (temp != null && temp.trim().length() != 0) {
            platform = Platform.valueOf(temp.trim());
        }
        System.setProperty(PLATFORM_PROPERTY_KEY, platform.toString());
        switch (platform) {
            case Felix: {
                logger.info("Launching GlassFish on Apache Felix OSGi platform");
                new ASMainFelix(logger, args).run();
                break;
            }
            case Equinox: {
                logger.info("Launching GlassFish on Equinox OSGi platform");
                new ASMainEquinox(logger, args).run();
                break;
            }
            case Knopflerfish: 
            case KnopflerFish: {
                logger.info("Launching GlassFish on Knopflerfish OSGi platform");
                new ASMainKnopflerFish(logger, args).run();
                break;
            }
            case HK2: {
                throw new RuntimeException("GlassFish does not run on the HK2 platform anynmore");
            }
            case Static: {
                new ASMainStatic(logger, args).run();
                break;
            }
            default: {
                throw new RuntimeException("Platform not yet supported");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Platform {
        HK2,
        Felix,
        Knopflerfish,
        KnopflerFish,
        Equinox,
        Static;

    }
}

