/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.context;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialResponseWriter
extends ResponseWriterWrapper {
    private boolean inChanges = false;
    private boolean inInsertBefore = false;
    private boolean inInsertAfter = false;
    CDataEscapingResponseWriter writer;
    private static final String STARTCDATA = "<![CDATA[";
    private static final String ENDCDATA = "]]>";
    public static final String RENDER_ALL_MARKER = "javax.faces.ViewRoot";
    public static final String VIEW_STATE_MARKER = "javax.faces.ViewState";

    public PartialResponseWriter(ResponseWriter writer) {
        this.writer = new CDataEscapingResponseWriter(writer);
    }

    @Override
    public ResponseWriter getWrapped() {
        return this.writer;
    }

    @Override
    public void startDocument() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        this.writer.startElement("partial-response", null);
    }

    @Override
    public void endDocument() throws IOException {
        this.endChangesIfNecessary();
        this.writer.endElement("partial-response");
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertBefore = true;
        this.writer.startElement("insert", null);
        this.writer.startElement("before", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.write(STARTCDATA);
        this.writer.setInCdata(true);
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertAfter = true;
        this.writer.startElement("insert", null);
        this.writer.startElement("after", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.write(STARTCDATA);
        this.writer.setInCdata(true);
    }

    public void endInsert() throws IOException {
        this.writer.endElement("CDATA");
        if (this.inInsertBefore) {
            this.writer.endElement("before");
            this.inInsertBefore = false;
        } else if (this.inInsertAfter) {
            this.writer.endElement("after");
            this.inInsertAfter = false;
        }
        this.writer.endElement("insert");
    }

    public void startUpdate(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("update", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.write(STARTCDATA);
        this.writer.setInCdata(true);
    }

    public void endUpdate() throws IOException {
        this.writer.setInCdata(false);
        this.writer.write(ENDCDATA);
        this.writer.endElement("update");
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("attributes", null);
        this.writer.writeAttribute("id", targetId, null);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            this.writer.startElement("attribute", null);
            this.writer.writeAttribute("name", entry.getKey(), null);
            this.writer.writeAttribute("value", entry.getValue(), null);
            this.writer.endElement("attribute");
        }
        this.writer.endElement("attributes");
    }

    public void delete(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("delete", null);
        this.writer.writeAttribute("id", targetId, null);
        this.writer.endElement("delete");
    }

    public void redirect(String url) throws IOException {
        this.endChangesIfNecessary();
        this.writer.startElement("redirect", null);
        this.writer.writeAttribute("url", url, null);
        this.writer.endElement("redirect");
    }

    public void startEval() throws IOException {
        this.startChangesIfNecessary();
        this.writer.startElement("eval", null);
        this.writer.write(STARTCDATA);
        this.writer.setInCdata(true);
    }

    public void endEval() throws IOException {
        this.writer.setInCdata(false);
        this.writer.write(ENDCDATA);
        this.writer.endElement("eval");
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.endChangesIfNecessary();
        this.writer.startElement("extension", null);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writer.writeAttribute(entry.getKey(), entry.getValue(), null);
            }
        }
    }

    public void endExtension() throws IOException {
        this.writer.endElement("extension");
    }

    public void startError(String errorName) throws IOException {
        this.endChangesIfNecessary();
        this.writer.startElement("error", null);
        this.writer.startElement("error-name", null);
        this.writer.write(errorName);
        this.writer.endElement("error-name");
        this.writer.startElement("error-message", null);
        this.writer.write(STARTCDATA);
        this.writer.setInCdata(true);
    }

    public void endError() throws IOException {
        this.writer.setInCdata(false);
        this.writer.write(ENDCDATA);
        this.writer.endElement("error-message");
        this.writer.endElement("error");
    }

    private void startChangesIfNecessary() throws IOException {
        if (!this.inChanges) {
            this.writer.startElement("changes", null);
            this.inChanges = true;
        }
    }

    private void endChangesIfNecessary() throws IOException {
        if (this.inChanges) {
            this.writer.endElement("changes");
            this.inChanges = false;
        }
    }

    private static class CDataEscapingResponseWriter
    extends ResponseWriterWrapper {
        private static final String BREAKCDATA = "]]><![CDATA[";
        private static final String ESCAPEDSINGLEBRACKET = "]]]><![CDATA[";
        private static final String ESCAPEDLT = "&lt;]]><![CDATA[";
        private static final String ESCAPEDSTART = "&lt;]]><![CDATA[!";
        private static final String ESCAPEDEND = "]]]><![CDATA[]";
        private static final int CLOSEBRACKET = 93;
        private static final int LT = 60;
        private boolean inCdata = false;
        ResponseWriter writer;

        private CDataEscapingResponseWriter(ResponseWriter writer) {
            this.writer = writer;
        }

        public ResponseWriter getWrapped() {
            return this.writer;
        }

        public void setInCdata(boolean inCdata) {
            this.inCdata = inCdata;
        }

        public void writeText(Object text, String property) throws IOException {
            if (text == null) {
                this.getWrapped().writeText(text, property);
                return;
            }
            if (this.inCdata) {
                this.getWrapped().write(this.escapeArray(text.toString().toCharArray()));
            } else {
                this.getWrapped().writeText(text, property);
            }
        }

        public void writeText(Object text, UIComponent component, String property) throws IOException {
            if (text == null) {
                this.getWrapped().writeText(text, component, property);
                return;
            }
            if (this.inCdata) {
                this.getWrapped().write(this.escapeArray(text.toString().toCharArray()));
            } else {
                this.getWrapped().writeText(text, component, property);
            }
        }

        public void writeText(char[] text, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > text.length) {
                throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > text.length");
            }
            if (this.inCdata) {
                char[] cbuf = new char[off + len];
                int i = off;
                for (int j = 0; j < len; ++j) {
                    cbuf[j] = text[i];
                    ++i;
                }
                this.getWrapped().write(this.escapeArray(cbuf));
            } else {
                this.getWrapped().writeText(text, off, len);
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > cbuf.length) {
                throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > cbuf.length");
            }
            if (this.inCdata) {
                char[] nbuf = new char[off + len];
                int i = off;
                for (int j = 0; j < len; ++j) {
                    nbuf[j] = cbuf[i];
                    ++i;
                }
                this.getWrapped().write(this.escapeArray(nbuf));
            } else {
                this.getWrapped().write(cbuf, off, len);
            }
        }

        public void write(char[] cbuf) throws IOException {
            if (this.inCdata) {
                this.getWrapped().write(this.escapeArray(cbuf));
            } else {
                this.getWrapped().write(cbuf);
            }
        }

        public void write(int c) throws IOException {
            if (this.inCdata) {
                if (c == 93) {
                    this.inCdata = false;
                    this.getWrapped().write(ESCAPEDSINGLEBRACKET);
                    this.inCdata = true;
                } else if (c == 60) {
                    this.getWrapped().write(ESCAPEDLT);
                } else {
                    this.getWrapped().write(c);
                }
            } else {
                this.getWrapped().write(c);
            }
        }

        public void write(String str) throws IOException {
            if (str == null) {
                this.getWrapped().write(str);
                return;
            }
            if (this.inCdata) {
                this.write(str.toCharArray());
            } else {
                this.getWrapped().write(str);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > str.length()) {
                throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > str.length()");
            }
            if (this.inCdata) {
                this.write(str.substring(off, off + len).toCharArray());
            } else {
                this.getWrapped().write(str, off, len);
            }
        }

        private String escapeArray(char[] cbuf) {
            if (cbuf == null || cbuf.length == 0) {
                return "";
            }
            boolean last = false;
            StringBuilder builder = new StringBuilder(cbuf.length);
            for (int i = 0; i < cbuf.length - 1; ++i) {
                if (cbuf[i] == '<' && cbuf[i + 1] == '!') {
                    builder.append(ESCAPEDSTART);
                    ++i;
                } else if (cbuf[i] == ']' && cbuf[i + 1] == ']') {
                    builder.append(ESCAPEDEND);
                    ++i;
                } else {
                    builder.append(cbuf[i]);
                }
                if (i != cbuf.length - 1) continue;
                last = true;
            }
            if (!last) {
                if (cbuf[cbuf.length - 1] == '<') {
                    builder.append(ESCAPEDLT);
                } else if (cbuf[cbuf.length - 1] == '[') {
                    builder.append(ESCAPEDSINGLEBRACKET);
                } else {
                    builder.append(cbuf[cbuf.length - 1]);
                }
            }
            return builder.toString();
        }
    }
}

