/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Image;
import java.io.File;
import java.io.IOException;

class LinkAction
extends Action {
    Image img;
    String path = "";
    String target = "";

    LinkAction(Image image, String[] tokens) {
        super(8);
        this.img = image;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].startsWith("target=")) {
                this.target = tokens[i].substring(7);
                continue;
            }
            if (!tokens[i].startsWith("path=")) continue;
            this.path = tokens[i].substring(5);
        }
    }

    void install(Action orig) throws IOException {
        if (isPosix) {
            File f = new File(this.img.getRootDirectory(), this.path);
            if (f.exists()) {
                f.delete();
            }
            String[] cmd = new String[]{"/bin/ln", "-fs", this.target, f.getCanonicalPath()};
            try {
                Process p = Runtime.getRuntime().exec(cmd, null, this.img.getRootDirectory());
                p.waitFor();
                if (p.exitValue() != 0) {
                    throw new Error("/bin/ln -fs failed");
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    void remove() throws IOException {
        File f = new File(this.img.getRootDirectory(), this.path);
        this.setPermissions(f, "0644");
        f.delete();
    }

    String keyValue() {
        return this.path;
    }

    public String toString() {
        return "link: path=" + this.path;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof LinkAction)) {
            return true;
        }
        LinkAction la = (LinkAction)a;
        return !this.equals(a) || !this.target.equals(la.target);
    }
}

