/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.MultiViewHandler;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.webapp.pdl.PageDeclarationLanguage;

public abstract class ViewHandlingStrategy
extends PageDeclarationLanguage {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    protected boolean responseBufferSizeSet;
    protected int responseBufferSize;
    protected ApplicationAssociate associate;
    protected WebConfiguration webConfig;
    protected MultiViewHandler multiViewHandler;

    public ViewHandlingStrategy() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.webConfig = WebConfiguration.getInstance(ctx.getExternalContext());
        this.associate = ApplicationAssociate.getInstance(ctx.getExternalContext());
        try {
            this.responseBufferSizeSet = this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ResponseBufferSize);
            this.responseBufferSize = Integer.parseInt(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResponseBufferSize));
        }
        catch (NumberFormatException nfe) {
            this.responseBufferSize = Integer.parseInt(WebConfiguration.WebContextInitParameter.ResponseBufferSize.getDefaultValue());
        }
    }

    public UIViewRoot restoreView(FacesContext ctx, String viewId) {
        ExternalContext extContext = ctx.getExternalContext();
        String mapping = Util.getFacesMapping(ctx);
        UIViewRoot viewRoot = null;
        if (extContext.getRequestPathInfo() == null && mapping != null && Util.isPrefixMapped(mapping)) {
            try {
                ctx.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response Complete for" + viewId);
                }
                extContext.redirect(extContext.getRequestContextPath());
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        } else {
            ViewHandler outerViewHandler = ctx.getApplication().getViewHandler();
            String renderKitId = outerViewHandler.calculateRenderKitId(ctx);
            viewRoot = Util.getStateManager(ctx).restoreView(ctx, viewId, renderKitId);
        }
        return viewRoot;
    }

    public UIViewRoot createView(FacesContext ctx, String viewId) {
        Util.notNull("context", ctx);
        UIViewRoot result = (UIViewRoot)ctx.getApplication().createComponent("javax.faces.ViewRoot");
        result.setViewId(viewId);
        Locale locale = null;
        String renderKitId = null;
        if (ctx.getViewRoot() != null) {
            locale = ctx.getViewRoot().getLocale();
            renderKitId = ctx.getViewRoot().getRenderKitId();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new view for " + viewId);
        }
        if (locale == null) {
            locale = ctx.getApplication().getViewHandler().calculateLocale(ctx);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locale for this view as determined by calculateLocale " + locale.toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using locale from previous view " + locale.toString());
        }
        if (renderKitId == null) {
            renderKitId = ctx.getApplication().getViewHandler().calculateRenderKitId(ctx);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RenderKitId for this view as determined by calculateRenderKitId " + renderKitId);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using renderKitId from previous view " + renderKitId);
        }
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        return result;
    }

    public abstract boolean handlesViewId(String var1);
}

