/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.component;

import com.sun.faces.facelets.tag.jstl.core.IterationStatus;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.faces.render.Renderer;

public class UIRepeat
extends UINamingContainer {
    public static final String COMPONENT_TYPE = "facelets.ui.Repeat";
    public static final String COMPONENT_FAMILY = "facelets";
    private static final DataModel EMPTY_MODEL = new ListDataModel(Collections.EMPTY_LIST);
    private Object value;
    private transient DataModel model;
    private String var;
    private String varStatus;
    private int index = -1;
    private int offset = -1;
    private int size = -1;
    private int step = -1;
    private transient StringBuffer buffer;
    private transient Object origValueOfVar;
    private transient Object origValueOfVarStatus;
    private Map childState;
    private static final SavedState NullState = new SavedState();

    public UIRepeat() {
        this.setRendererType(COMPONENT_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getOffset() {
        if (this.offset != -1) {
            return this.offset;
        }
        ValueBinding vb = this.getValueBinding("offset");
        if (vb != null) {
            return (Integer)vb.getValue(FacesContext.getCurrentInstance());
        }
        return 0;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getStep() {
        if (this.step != -1) {
            return this.step;
        }
        ValueBinding vb = this.getValueBinding("offset");
        if (vb != null) {
            return (Integer)vb.getValue(FacesContext.getCurrentInstance());
        }
        return 1;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getSize() {
        if (this.size != -1) {
            return this.size;
        }
        ValueBinding vb = this.getValueBinding("size");
        if (vb != null) {
            return (Integer)vb.getValue(FacesContext.getCurrentInstance());
        }
        return -1;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
    }

    private void resetDataModel() {
        if (this.isNestedInIterator()) {
            this.setDataModel(null);
        }
    }

    private void setDataModel(DataModel model) {
        this.model = model;
    }

    private DataModel getDataModel() {
        if (this.model == null) {
            Object val = this.getValue();
            this.model = val == null ? EMPTY_MODEL : (val instanceof DataModel ? (DataModel)val : (val instanceof List ? new ListDataModel((List)val) : (Object[].class.isAssignableFrom(val.getClass()) ? new ArrayDataModel((Object[])val) : (val instanceof ResultSet ? new ResultSetDataModel((ResultSet)val) : new ScalarDataModel(val)))));
        }
        return this.model;
    }

    public Object getValue() {
        ValueBinding vb;
        if (this.value == null && (vb = this.getValueBinding("value")) != null) {
            return vb.getValue(FacesContext.getCurrentInstance());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private StringBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.setLength(0);
        return this.buffer;
    }

    public String getClientId(FacesContext faces) {
        String id = super.getClientId(faces);
        if (this.index >= 0) {
            id = this.getBuffer().append(id).append(UIRepeat.getSeparatorChar((FacesContext)faces)).append(this.index).toString();
        }
        return id;
    }

    private void captureOrigValue() {
        if (this.var != null || this.varStatus != null) {
            FacesContext faces = FacesContext.getCurrentInstance();
            Map attrs = faces.getExternalContext().getRequestMap();
            if (this.var != null) {
                this.origValueOfVar = attrs.get(this.var);
            }
            if (this.varStatus != null) {
                this.origValueOfVarStatus = attrs.get(this.varStatus);
            }
        }
    }

    private void restoreOrigValue() {
        if (this.var != null || this.varStatus != null) {
            FacesContext faces = FacesContext.getCurrentInstance();
            Map attrs = faces.getExternalContext().getRequestMap();
            if (this.var != null) {
                if (this.origValueOfVar != null) {
                    attrs.put(this.var, this.origValueOfVar);
                } else {
                    attrs.remove(this.var);
                }
            }
            if (this.varStatus != null) {
                if (this.origValueOfVarStatus != null) {
                    attrs.put(this.varStatus, this.origValueOfVarStatus);
                } else {
                    attrs.remove(this.varStatus);
                }
            }
        }
    }

    private Map getChildState() {
        if (this.childState == null) {
            this.childState = new HashMap();
        }
        return this.childState;
    }

    private void saveChildState() {
        if (this.getChildCount() > 0) {
            FacesContext faces = FacesContext.getCurrentInstance();
            Iterator itr = this.getChildren().iterator();
            while (itr.hasNext()) {
                this.saveChildState(faces, (UIComponent)itr.next());
            }
        }
    }

    private void saveChildState(FacesContext faces, UIComponent c) {
        if (c instanceof EditableValueHolder && !c.isTransient()) {
            String clientId = c.getClientId(faces);
            SavedState ss = (SavedState)this.getChildState().get(clientId);
            if (ss == null) {
                ss = new SavedState();
                this.getChildState().put(clientId, ss);
            }
            ss.populate((EditableValueHolder)c);
        }
        Iterator itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this.saveChildState(faces, (UIComponent)itr.next());
        }
    }

    private void restoreChildState() {
        if (this.getChildCount() > 0) {
            FacesContext faces = FacesContext.getCurrentInstance();
            Iterator itr = this.getChildren().iterator();
            while (itr.hasNext()) {
                this.restoreChildState(faces, (UIComponent)itr.next());
            }
        }
    }

    private void restoreChildState(FacesContext faces, UIComponent c) {
        String id = c.getId();
        c.setId(id);
        if (c instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)c;
            String clientId = c.getClientId(faces);
            SavedState ss = (SavedState)this.getChildState().get(clientId);
            if (ss != null) {
                ss.apply(evh);
            } else {
                NullState.apply(evh);
            }
        }
        Iterator itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this.restoreChildState(faces, (UIComponent)itr.next());
        }
    }

    private boolean keepSaved(FacesContext context) {
        for (String clientId : this.getChildState().keySet()) {
            Iterator messages = context.getMessages(clientId);
            while (messages.hasNext()) {
                FacesMessage message = (FacesMessage)messages.next();
                if (message.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
                return true;
            }
        }
        return this.isNestedInIterator();
    }

    private boolean isNestedInIterator() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData) && !(parent instanceof UIRepeat)) continue;
            return true;
        }
        return false;
    }

    private void setIndex(int index) {
        this.saveChildState();
        this.index = index;
        DataModel localModel = this.getDataModel();
        localModel.setRowIndex(index);
        if (this.index != -1 && this.var != null && localModel.isRowAvailable()) {
            FacesContext faces = FacesContext.getCurrentInstance();
            Map attrs = faces.getExternalContext().getRequestMap();
            attrs.put(this.var, localModel.getRowData());
        }
        this.restoreChildState();
    }

    private void updateIterationStatus(IterationStatus status) {
        if (this.varStatus != null) {
            FacesContext faces = FacesContext.getCurrentInstance();
            Map attrs = faces.getExternalContext().getRequestMap();
            attrs.put(this.varStatus, status);
        }
    }

    private boolean isIndexAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public void process(FacesContext faces, PhaseId phase) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel();
        this.captureOrigValue();
        this.setIndex(-1);
        try {
            if (this.getChildCount() > 0) {
                int begin = this.getOffset();
                int num = this.getSize();
                int step = this.getStep();
                int rowCount = this.getDataModel().getRowCount();
                int end = Math.min(num > 0 ? begin + num - 1 : rowCount, rowCount);
                String rendererType = this.getRendererType();
                Renderer renderer = null;
                if (rendererType != null) {
                    renderer = this.getRenderer(faces);
                }
                int i = begin;
                this.setIndex(i);
                this.updateIterationStatus(new IterationStatus(true, i + step >= end, i, begin, end, step));
                while (i <= end && this.isIndexAvailable()) {
                    if (PhaseId.RENDER_RESPONSE.equals(phase) && renderer != null) {
                        renderer.encodeChildren(faces, (UIComponent)this);
                    } else {
                        for (UIComponent c : this.getChildren()) {
                            if (PhaseId.APPLY_REQUEST_VALUES.equals(phase)) {
                                c.processDecodes(faces);
                                continue;
                            }
                            if (PhaseId.PROCESS_VALIDATIONS.equals(phase)) {
                                c.processValidators(faces);
                                continue;
                            }
                            if (PhaseId.UPDATE_MODEL_VALUES.equals(phase)) {
                                c.processUpdates(faces);
                                continue;
                            }
                            if (!PhaseId.RENDER_RESPONSE.equals(phase)) continue;
                            c.encodeAll(faces);
                        }
                    }
                    this.setIndex(i += step);
                    this.updateIterationStatus(new IterationStatus(false, i + step >= end, i, begin, end, step));
                }
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this.setIndex(-1);
            this.restoreOrigValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext faces, String clientId, ContextCallback callback) throws FacesException {
        String id = super.getClientId(faces);
        if (clientId.equals(id)) {
            callback.invokeContextCallback(faces, (UIComponent)this);
            return true;
        }
        if (clientId.startsWith(id)) {
            int prevIndex = this.index;
            int idxStart = clientId.indexOf(UIRepeat.getSeparatorChar((FacesContext)faces), id.length());
            if (idxStart != -1 && Character.isDigit(clientId.charAt(idxStart + 1))) {
                int idxEnd = clientId.indexOf(UIRepeat.getSeparatorChar((FacesContext)faces), idxStart + 1);
                if (idxEnd != -1) {
                    int newIndex = Integer.parseInt(clientId.substring(idxStart + 1, idxEnd));
                    boolean found = false;
                    try {
                        this.captureOrigValue();
                        this.setIndex(newIndex);
                        if (this.isIndexAvailable()) {
                            found = super.invokeOnComponent(faces, clientId, callback);
                        }
                    }
                    finally {
                        this.setIndex(prevIndex);
                        this.restoreOrigValue();
                    }
                    return found;
                }
            } else {
                return super.invokeOnComponent(faces, clientId, callback);
            }
        }
        return false;
    }

    public void processDecodes(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this.keepSaved(faces)) {
            this.childState = null;
        }
        this.process(faces, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(faces);
    }

    public void processUpdates(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel();
        this.process(faces, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void processValidators(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel();
        this.process(faces, PhaseId.PROCESS_VALIDATIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof IndexedEvent) {
            IndexedEvent idxEvent = (IndexedEvent)event;
            this.resetDataModel();
            int prevIndex = this.index;
            try {
                this.setIndex(idxEvent.getIndex());
                if (!this.isIndexAvailable()) return;
                FacesEvent target = idxEvent.getTarget();
                target.getComponent().broadcast(target);
                return;
            }
            finally {
                this.setIndex(prevIndex);
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new IndexedEvent(this, event, this.index));
    }

    public void restoreState(FacesContext faces, Object object) {
        Object[] state = (Object[])object;
        super.restoreState(faces, state[0]);
        this.childState = (Map)state[1];
        this.offset = (Integer)state[2];
        this.size = (Integer)state[3];
        this.step = (Integer)state[4];
        this.var = (String)state[5];
        this.varStatus = (String)state[6];
        this.value = state[7];
    }

    public Object saveState(FacesContext faces) {
        Object[] state = new Object[]{super.saveState(faces), this.childState, this.offset, this.size, this.step, this.var, this.varStatus, this.value};
        return state;
    }

    public void encodeChildren(FacesContext faces) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this.keepSaved(faces)) {
            this.childState = null;
        }
        this.process(faces, PhaseId.RENDER_RESPONSE);
    }

    public boolean getRendersChildren() {
        Renderer renderer = null;
        if (this.getRendererType() != null && null != (renderer = this.getRenderer(this.getFacesContext()))) {
            return renderer.getRendersChildren();
        }
        return true;
    }

    private static final class IndexedEvent
    extends FacesEvent {
        private final FacesEvent target;
        private final int index;

        public IndexedEvent(UIRepeat owner, FacesEvent target, int index) {
            super((UIComponent)owner);
            this.target = target;
            this.index = index;
        }

        public PhaseId getPhaseId() {
            return this.target.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.target.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return this.target.isAppropriateListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processListener(FacesListener listener) {
            UIRepeat owner = (UIRepeat)this.getComponent();
            int prevIndex = owner.index;
            try {
                owner.setIndex(this.index);
                if (owner.isIndexAvailable()) {
                    this.target.processListener(listener);
                }
            }
            finally {
                owner.setIndex(prevIndex);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public FacesEvent getTarget() {
            return this.target;
        }
    }

    private static final class SavedState
    implements Serializable {
        private Object submittedValue;
        private static final long serialVersionUID = 2920252657338389849L;
        private boolean valid = true;
        private Object value;
        private boolean localValueSet;

        private SavedState() {
        }

        Object getSubmittedValue() {
            return this.submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this.submittedValue = submittedValue;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        boolean isLocalValueSet() {
            return this.localValueSet;
        }

        public void setLocalValueSet(boolean localValueSet) {
            this.localValueSet = localValueSet;
        }

        public String toString() {
            return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet;
        }

        public void populate(EditableValueHolder evh) {
            this.value = evh.getValue();
            this.valid = evh.isValid();
            this.submittedValue = evh.getSubmittedValue();
            this.localValueSet = evh.isLocalValueSet();
        }

        public void apply(EditableValueHolder evh) {
            evh.setValue(this.value);
            evh.setValid(this.valid);
            evh.setSubmittedValue(this.submittedValue);
            evh.setLocalValueSet(this.localValueSet);
        }
    }
}

