/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.factory.sun;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.sun.TableRowGroupFactory;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutStaticText;
import com.sun.jsftemplating.layout.event.CreateChildEvent;
import java.util.ArrayList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicColumnTableRowGroupFactory
extends TableRowGroupFactory {
    public static final String COLUMN_TYPE = "sun:tableColumn";
    public static final String COLUMN_VALUE_KEY = "columnValue";
    public static final String COLUMN_SEPERATOR = "col";
    public static final String CHILD_SUFFIX = "child";
    public static final int COLUMN_LEN = "column".length();

    @Override
    public UIComponent create(FacesContext context, LayoutComponent desc, UIComponent parent) {
        UIComponent comp = super.create(context, desc, parent);
        String id = comp.getId();
        ArrayList<String> colAttKeys = new ArrayList<String>();
        for (String key : desc.getOptions().keySet()) {
            if (!key.startsWith("column")) continue;
            colAttKeys.add(key);
        }
        if (colAttKeys.size() == 0) {
            return comp;
        }
        List<Object> values = this.getColumnPropertyValues(context, desc, (String)colAttKeys.get(0), parent);
        int size = values.size();
        ArrayList<LayoutComponent> columns = new ArrayList<LayoutComponent>(size);
        ComponentType colType = LayoutDefinitionManager.getGlobalComponentType(COLUMN_TYPE);
        for (int idx = 0; idx < size; ++idx) {
            LayoutComponent column = new LayoutComponent(desc, id + COLUMN_SEPERATOR + idx, colType);
            columns.add(column);
        }
        for (String key : colAttKeys) {
            if (key.equals(COLUMN_VALUE_KEY)) continue;
            values = this.getColumnPropertyValues(context, desc, key, parent);
            int idx = 0;
            for (Object entry : values) {
                ((LayoutComponent)columns.get(idx++)).addOption(this.getColumnKey(key), entry);
            }
        }
        UIComponent columnComp = null;
        String value = null;
        Object eventVal = null;
        values = this.getColumnPropertyValues(context, desc, COLUMN_VALUE_KEY, parent);
        int idx = 0;
        for (LayoutComponent columnDesc : columns) {
            columnComp = ComponentUtil.createChildComponent(context, columnDesc, comp);
            eventVal = desc.dispatchHandlers(context, "createChild", new CreateChildEvent(columnComp, value = "" + values.get(idx++)));
            if (eventVal != null && eventVal instanceof UIComponent) {
                columnComp.getChildren().add((UIComponent)eventVal);
                continue;
            }
            ComponentUtil.createChildComponent(context, new LayoutStaticText((LayoutElement)columnDesc, columnDesc.getUnevaluatedId() + CHILD_SUFFIX, value), columnComp);
        }
        return comp;
    }

    private List<Object> getColumnPropertyValues(FacesContext context, LayoutComponent parentDesc, String propertyName, UIComponent parent) {
        Object val = parentDesc.getEvaluatedOption(context, propertyName, parent);
        if (val == null) {
            throw new IllegalArgumentException("DynamicColumnTableRowGroupFactory requires a valid '" + propertyName + "' attribute, however one was not supplied!");
        }
        if (val instanceof String && ComponentUtil.isValueReference((String)val)) {
            ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), (String)val, Object.class);
            val = ve.getValue(context.getELContext());
        }
        if (!(val instanceof List)) {
            throw new IllegalArgumentException("DynamicColumnTableRowGroupFactory requires all 'column*' properties to resolve to an instance of a List. '" + propertyName + "' is a '" + val.getClass().getName() + "'!");
        }
        return (List)val;
    }

    private String getColumnKey(String key) {
        return key.substring(COLUMN_LEN, COLUMN_LEN + 1).toLowerCase() + key.substring(COLUMN_LEN + 1);
    }

    @Override
    protected void setOption(FacesContext context, UIComponent comp, LayoutComponent desc, String key, Object value) {
        if (key.startsWith("column")) {
            return;
        }
        super.setOption(context, comp, desc, key, value);
    }
}

