/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbAsyncInvocationManager;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Timer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public class EjbContainerUtilImpl
implements PostConstruct,
PreDestroy,
EjbContainerUtil {
    private Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private ExecutorService executorService;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerContext serverContext;
    private EJBTimerService _ejbTimerService;
    private Map<Long, BaseContainer> id2Container = new ConcurrentHashMap<Long, BaseContainer>();
    private Timer _timer = new Timer(true);
    private boolean _insideContainer = true;
    @Inject
    private InvocationManager _invManager;
    @Inject
    private InjectionManager _injectionManager;
    @Inject
    private GlassfishNamingManager _gfNamingManager;
    @Inject
    private ComponentEnvManager _compEnvManager;
    @Inject
    private JavaEETransactionManager txMgr;
    @Inject
    private EjbContainer ejbContainer;
    @Inject
    private GlassFishORBHelper orbHelper;
    @Inject
    private ServerEnvironmentImpl env;
    @Inject(optional=true)
    private Agent callFlowAgent;
    @Inject
    private EJBServerConfigLookup ejbServerConfigLookup;
    @Inject
    private EjbAsyncInvocationManager ejbAsyncInvocationManager;
    private static EjbContainerUtil _me;

    public String getHAPersistenceType() {
        return this.ejbServerConfigLookup.getSfsbHaPersistenceTypeFromConfig();
    }

    public void postConstruct() {
        if (this.callFlowAgent == null) {
            this.callFlowAgent = (Agent)Proxy.newProxyInstance(EjbContainerUtilImpl.class.getClassLoader(), new Class[]{Agent.class}, new InvocationHandler(){

                public Object invoke(Object proxy, Method m, Object[] args) {
                    return null;
                }
            });
        }
        EjbTimerThreadFactory tf = new EjbTimerThreadFactory();
        this.executorService = Executors.newCachedThreadPool(tf);
        _me = this;
    }

    public void preDestroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    public GlassFishORBHelper getORBHelper() {
        return this.orbHelper;
    }

    public Habitat getDefaultHabitat() {
        return this.habitat;
    }

    public static EjbContainerUtil getInstance() {
        if (_me == null) {
            _me = (EjbContainerUtil)Globals.getDefaultHabitat().getComponent(EjbContainerUtilImpl.class);
            _me.getLogger().log(Level.WARNING, "Internal error: EJBContainerUtilImpl was null", new Throwable());
        }
        return _me;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setEJBTimerService(EJBTimerService es) {
        this._ejbTimerService = es;
    }

    public EJBTimerService getEJBTimerService() {
        return this._ejbTimerService;
    }

    public void registerContainer(BaseContainer container) {
        this.id2Container.put(container.getContainerId(), container);
    }

    public void unregisterContainer(BaseContainer container) {
        this.id2Container.remove(container.getContainerId());
    }

    public BaseContainer getContainer(long id) {
        return this.id2Container.get(id);
    }

    public EjbDescriptor getDescriptor(long id) {
        BaseContainer container = this.id2Container.get(id);
        return container != null ? container.getEjbDescriptor() : null;
    }

    public ClassLoader getClassLoader(long id) {
        BaseContainer container = this.id2Container.get(id);
        return container != null ? container.getClassLoader() : null;
    }

    public Timer getTimer() {
        return this._timer;
    }

    public void setInsideContainer(boolean bool) {
        this._insideContainer = bool;
    }

    public boolean isInsideContainer() {
        return this._insideContainer;
    }

    public InvocationManager getInvocationManager() {
        return this._invManager;
    }

    public InjectionManager getInjectionManager() {
        return this._injectionManager;
    }

    public GlassfishNamingManager getGlassfishNamingManager() {
        return this._gfNamingManager;
    }

    public ComponentEnvManager getComponentEnvManager() {
        return this._compEnvManager;
    }

    public ComponentInvocation getCurrentInvocation() {
        return this._invManager.getCurrentInvocation();
    }

    public JavaEETransactionManager getTransactionManager() {
        return this.txMgr;
    }

    public ServerContext getServerContext() {
        return this.serverContext;
    }

    public EjbAsyncInvocationManager getEjbAsyncInvocationManager() {
        return this.ejbAsyncInvocationManager;
    }

    private TxData getTxData(JavaEETransaction tx) {
        TxData txData = (TxData)tx.getContainerData();
        if (txData == null) {
            txData = new TxData();
            tx.setContainerData((Object)txData);
        }
        return txData;
    }

    public ContainerSynchronization getContainerSync(Transaction jtx) throws RollbackException, SystemException {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        if (txData.sync == null) {
            txData.sync = new ContainerSynchronization((Transaction)tx, this);
            tx.registerSynchronization((Synchronization)txData.sync);
        }
        return txData.sync;
    }

    public void removeContainerSync(Transaction tx) {
    }

    public EjbContainer getEjbContainer() {
        return this.ejbContainer;
    }

    public ServerEnvironmentImpl getServerEnvironment() {
        return this.env;
    }

    public Vector getBeans(Transaction jtx) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        if (txData.beans == null) {
            txData.beans = new Vector();
        }
        return txData.beans;
    }

    public Object getActiveTxCache(Transaction jtx) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        return txData.activeTxCache;
    }

    public void setActiveTxCache(Transaction jtx, Object cache) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        txData.activeTxCache = cache;
    }

    public Agent getCallFlowAgent() {
        return this.callFlowAgent;
    }

    public void addWork(Runnable task) {
        this.executorService.submit(task);
    }

    public EjbDescriptor ejbIdToDescriptor(long ejbId) {
        throw new RuntimeException("Not supported yet");
    }

    private class TxData {
        ContainerSynchronization sync;
        Vector beans;
        Object activeTxCache;

        private TxData() {
        }
    }

    private static class EjbTimerThreadFactory
    implements ThreadFactory {
        private AtomicInteger threadId = new AtomicInteger(0);

        private EjbTimerThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, "Ejb-Timer-Thread-" + this.threadId.incrementAndGet());
            th.setDaemon(true);
            th.setContextClassLoader(null);
            return th;
        }
    }
}

